/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Optional;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.irac.DefaultIracVersionGenerator;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.infinispan.xsite.XSiteNamedCache;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="xsite.irac.IracVersionUnitTest")
public class IracVersionUnitTest
extends AbstractInfinispanTest {
    private static final String SITE_1 = "site_1";
    private static final String SITE_2 = "site_2";

    private static DefaultIracVersionGenerator newGenerator(String site) {
        DefaultIracVersionGenerator generator = new DefaultIracVersionGenerator(2);
        TestingUtil.inject(generator, IracVersionUnitTest.mockRpcManager(site), IracVersionUnitTest.mockGlobalStateManager(), IracVersionUnitTest.mockCommandFactory());
        generator.start();
        return generator;
    }

    private static Transport mockTransport(String siteName) {
        Transport t = (Transport)Mockito.mock(Transport.class);
        ((Transport)Mockito.doNothing().when((Object)t)).checkCrossSiteAvailable();
        Mockito.when((Object)t.localSiteName()).thenReturn((Object)siteName);
        return t;
    }

    private static RpcManager mockRpcManager(String siteName) {
        Transport transport = IracVersionUnitTest.mockTransport(siteName);
        RpcManager rpcManager = (RpcManager)Mockito.mock(RpcManager.class);
        Mockito.when((Object)rpcManager.getTransport()).thenReturn((Object)transport);
        return rpcManager;
    }

    private static CacheTopology mockCacheTopology() {
        CacheTopology t = (CacheTopology)Mockito.mock(CacheTopology.class);
        Mockito.when((Object)t.getPhase()).thenReturn((Object)CacheTopology.Phase.NO_REBALANCE);
        return t;
    }

    private static GlobalStateManager mockGlobalStateManager() {
        GlobalStateManager manager = (GlobalStateManager)Mockito.mock(GlobalStateManager.class);
        ((GlobalStateManager)Mockito.doNothing().when((Object)manager)).writeScopedState((ScopedPersistentState)Mockito.any(ScopedPersistentState.class));
        Mockito.when((Object)manager.readScopedState(Mockito.anyString())).thenReturn(Optional.empty());
        return manager;
    }

    private static CommandsFactory mockCommandFactory() {
        CommandsFactory factory = (CommandsFactory)Mockito.mock(CommandsFactory.class);
        Mockito.when((Object)factory.getCacheName()).thenReturn((Object)"unused");
        return factory;
    }

    private static void assertSiteVersion(IracEntryVersion entryVersion, String site, int topologyId, long version) {
        AssertJUnit.assertNotNull((Object)entryVersion);
        TopologyIracVersion iracVersion = entryVersion.getVersion(XSiteNamedCache.cachedByteString((String)site));
        AssertJUnit.assertNotNull((Object)iracVersion);
        AssertJUnit.assertEquals((int)topologyId, (int)iracVersion.getTopologyId());
        AssertJUnit.assertEquals((long)version, (long)iracVersion.getVersion());
    }

    private static void assertNoSiteVersion(IracEntryVersion entryVersion, String site) {
        AssertJUnit.assertNotNull((Object)entryVersion);
        TopologyIracVersion iracVersion = entryVersion.getVersion(XSiteNamedCache.cachedByteString((String)site));
        AssertJUnit.assertNull((Object)iracVersion);
    }

    private static void triggerTopologyEvent(DefaultIracVersionGenerator generator) {
        generator.onTopologyChange(IracVersionUnitTest.mockCacheTopology());
    }

    public void testEquals() {
        IracMetadata m1 = IracVersionUnitTest.newGenerator(SITE_1).generateNewMetadata(0);
        IracMetadata m2 = IracVersionUnitTest.newGenerator(SITE_1).generateNewMetadata(0);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.EQUAL, (Object)m1.getVersion().compareTo(m2.getVersion()));
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.EQUAL, (Object)m2.getVersion().compareTo(m1.getVersion()));
    }

    public void testCompareDifferentTopology() {
        DefaultIracVersionGenerator g1 = IracVersionUnitTest.newGenerator(SITE_1);
        IracMetadata m1 = g1.generateNewMetadata(0);
        IracVersionUnitTest.triggerTopologyEvent(g1);
        IracMetadata m2 = g1.generateNewMetadata(0);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_1, 1, 1L);
        IracVersionUnitTest.assertNoSiteVersion(m1.getVersion(), SITE_2);
        IracVersionUnitTest.assertSiteVersion(m2.getVersion(), SITE_1, 2, 1L);
        IracVersionUnitTest.assertNoSiteVersion(m2.getVersion(), SITE_2);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.BEFORE, (Object)m1.getVersion().compareTo(m2.getVersion()));
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.AFTER, (Object)m2.getVersion().compareTo(m1.getVersion()));
    }

    public void testCompareSameTopology() {
        DefaultIracVersionGenerator g1 = IracVersionUnitTest.newGenerator(SITE_1);
        IracMetadata m1 = g1.generateNewMetadata(0);
        IracMetadata m2 = g1.generateNewMetadata(0);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_1, 1, 1L);
        IracVersionUnitTest.assertNoSiteVersion(m1.getVersion(), SITE_2);
        IracVersionUnitTest.assertSiteVersion(m2.getVersion(), SITE_1, 1, 2L);
        IracVersionUnitTest.assertNoSiteVersion(m2.getVersion(), SITE_2);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.BEFORE, (Object)m1.getVersion().compareTo(m2.getVersion()));
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.AFTER, (Object)m2.getVersion().compareTo(m1.getVersion()));
    }

    public void testCausality() {
        DefaultIracVersionGenerator g1 = IracVersionUnitTest.newGenerator(SITE_1);
        DefaultIracVersionGenerator g2 = IracVersionUnitTest.newGenerator(SITE_2);
        IracMetadata m2 = g2.generateNewMetadata(0);
        IracVersionUnitTest.assertNoSiteVersion(m2.getVersion(), SITE_1);
        IracVersionUnitTest.assertSiteVersion(m2.getVersion(), SITE_2, 1, 1L);
        g1.updateVersion(0, m2.getVersion());
        IracMetadata m1 = g1.generateNewMetadata(0);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_1, 1, 1L);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_2, 1, 1L);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.BEFORE, (Object)m2.getVersion().compareTo(m1.getVersion()));
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.AFTER, (Object)m1.getVersion().compareTo(m2.getVersion()));
    }

    public void testConflictSameTopology() {
        DefaultIracVersionGenerator g1 = IracVersionUnitTest.newGenerator(SITE_1);
        DefaultIracVersionGenerator g2 = IracVersionUnitTest.newGenerator(SITE_2);
        IracMetadata m1 = g1.generateNewMetadata(0);
        IracMetadata m2 = g2.generateNewMetadata(0);
        AssertJUnit.assertEquals((String)SITE_1, (String)m1.getSite());
        AssertJUnit.assertEquals((String)SITE_2, (String)m2.getSite());
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_1, 1, 1L);
        IracVersionUnitTest.assertNoSiteVersion(m1.getVersion(), SITE_2);
        IracVersionUnitTest.assertNoSiteVersion(m2.getVersion(), SITE_1);
        IracVersionUnitTest.assertSiteVersion(m2.getVersion(), SITE_2, 1, 1L);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.CONFLICTING, (Object)m1.getVersion().compareTo(m2.getVersion()));
    }

    public void testConflictDifferentTopology() {
        DefaultIracVersionGenerator g1 = IracVersionUnitTest.newGenerator(SITE_1);
        DefaultIracVersionGenerator g2 = IracVersionUnitTest.newGenerator(SITE_2);
        g2.generateNewMetadata(0);
        IracMetadata m2 = g2.generateNewMetadata(0);
        g1.updateVersion(0, m2.getVersion());
        IracMetadata m1 = g1.generateNewMetadata(0);
        IracVersionUnitTest.triggerTopologyEvent(g2);
        m2 = g2.generateNewMetadata(0);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_1, 1, 1L);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_2, 1, 2L);
        IracVersionUnitTest.assertNoSiteVersion(m2.getVersion(), SITE_1);
        IracVersionUnitTest.assertSiteVersion(m2.getVersion(), SITE_2, 2, 1L);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.CONFLICTING, (Object)m1.getVersion().compareTo(m2.getVersion()));
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.CONFLICTING, (Object)m2.getVersion().compareTo(m1.getVersion()));
    }

    public void testNoConflictDifferentTopology() {
        DefaultIracVersionGenerator g1 = IracVersionUnitTest.newGenerator(SITE_1);
        DefaultIracVersionGenerator g2 = IracVersionUnitTest.newGenerator(SITE_2);
        IracMetadata m3 = g2.generateNewMetadata(0);
        IracMetadata m2 = g2.generateNewMetadata(0);
        g1.updateVersion(0, m2.getVersion());
        IracMetadata m1 = g1.generateNewMetadata(0);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_1, 1, 1L);
        IracVersionUnitTest.assertSiteVersion(m1.getVersion(), SITE_2, 1, 2L);
        IracVersionUnitTest.assertNoSiteVersion(m3.getVersion(), SITE_1);
        IracVersionUnitTest.assertSiteVersion(m3.getVersion(), SITE_2, 1, 1L);
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.AFTER, (Object)m1.getVersion().compareTo(m3.getVersion()));
        AssertJUnit.assertEquals((Object)InequalVersionComparisonResult.BEFORE, (Object)m3.getVersion().compareTo(m1.getVersion()));
    }
}

