/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.TestOperation;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.irac.ManualIracManager;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.infinispan.xsite.spi.XSiteMergePolicy;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.IracAlwaysRemoveConflictTest")
public class IracAlwaysRemoveConflictTest
extends AbstractMultipleSitesTest {
    private static final int N_SITES = 2;
    private static final int CLUSTER_SIZE = 3;
    private final List<ManualIracManager> iracManagerList = new ArrayList<ManualIracManager>(6);

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        this.iracManagerList.clear();
    }

    protected IracAlwaysRemoveConflictTest() {
    }

    public void testPutIfAbsent(Method method) {
        this.doTest(method, TestOperation.PUT_IF_ABSENT);
    }

    public void testPut(Method method) {
        this.doTest(method, TestOperation.PUT);
    }

    public void testReplace(Method method) {
        this.doTest(method, TestOperation.REPLACE);
    }

    public void testConditionalReplace(Method method) {
        this.doTest(method, TestOperation.REPLACE_CONDITIONAL);
    }

    public void testRemove(Method method) {
        this.doTest(method, TestOperation.REMOVE);
    }

    public void testConditionalRemove(Method method) {
        this.doTest(method, TestOperation.REMOVE_CONDITIONAL);
    }

    @Override
    protected int defaultNumberOfSites() {
        return 2;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 3;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = IracAlwaysRemoveConflictTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        builder.sites().mergePolicy((XSiteEntryMergePolicy)XSiteMergePolicy.ALWAYS_REMOVE);
        for (int i = 0; i < 2; ++i) {
            if (i == siteIndex) continue;
            builder.sites().addBackup().site(this.siteName(i)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        }
        return builder;
    }

    @Override
    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        return builder;
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        this.iracManagerList.forEach(iracManager -> iracManager.disable(ManualIracManager.DisableMode.DROP));
        super.clearContent();
    }

    @Override
    protected void afterSitesCreated() {
        for (int i = 0; i < 2; ++i) {
            for (Cache cache : this.caches(this.siteName(i))) {
                this.iracManagerList.add(ManualIracManager.wrapCache(cache));
            }
        }
    }

    private void doTest(Method method, TestOperation testConfig) {
        int i;
        String initialValue;
        String key = TestingUtil.k(method, 0);
        String string = initialValue = testConfig.requiresPreviousValue() ? TestingUtil.v(method, 0) : null;
        if (testConfig.requiresPreviousValue()) {
            this.cache(this.siteName(0), 0).put((Object)key, (Object)initialValue);
        }
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals(initialValue, cache.get((Object)key)));
        this.iracManagerList.forEach(ManualIracManager::enable);
        String[] finalValues = new String[2];
        for (i = 0; i < 2; ++i) {
            String newValue = TestingUtil.v(method, (i + 1) * 2);
            if ((testConfig == TestOperation.REMOVE_CONDITIONAL || testConfig == TestOperation.REMOVE) && i > 0) {
                this.cache(this.siteName(i), 0).put((Object)key, (Object)newValue);
                finalValues[i] = newValue;
                continue;
            }
            finalValues[i] = testConfig.execute(this.cache(this.siteName(i), 0), key, initialValue, newValue);
        }
        for (i = 0; i < 2; ++i) {
            String fValue = finalValues[i];
            this.assertInSite(this.siteName(i), cache -> AssertJUnit.assertEquals((Object)fValue, (Object)cache.get((Object)key)));
        }
        this.iracManagerList.forEach(manualIracManager -> manualIracManager.disable(ManualIracManager.DisableMode.SEND));
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals(null, cache.get((Object)key)));
        this.assertNoDataLeak(null);
    }
}

