/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.util.BaseControlledConsistentHashFactory;
import org.testng.AssertJUnit;

public abstract class ControlledConsistentHashFactory<CH extends ConsistentHash>
extends BaseControlledConsistentHashFactory<CH> {
    private volatile int[][] ownerIndexes;
    private volatile List<Address> membersToUse;

    public ControlledConsistentHashFactory(BaseControlledConsistentHashFactory.Trait<CH> trait, int primaryOwnerIndex, int ... backupOwnerIndexes) {
        super(trait, 1);
        this.setOwnerIndexes(primaryOwnerIndex, backupOwnerIndexes);
    }

    public ControlledConsistentHashFactory(BaseControlledConsistentHashFactory.Trait<CH> trait, int[][] segmentOwners) {
        super(trait, segmentOwners.length);
        if (segmentOwners.length == 0) {
            throw new IllegalArgumentException("Need at least one set of owners");
        }
        this.setOwnerIndexes(segmentOwners);
    }

    public void setOwnerIndexes(int primaryOwnerIndex, int ... backupOwnerIndexes) {
        int[] firstSegmentOwners = this.concatOwners(primaryOwnerIndex, backupOwnerIndexes);
        this.setOwnerIndexes(new int[][]{firstSegmentOwners});
    }

    private int[] concatOwners(int primaryOwnerIndex, int[] backupOwnerIndexes) {
        int[] firstSegmentOwners;
        if (backupOwnerIndexes == null || backupOwnerIndexes.length == 0) {
            firstSegmentOwners = new int[]{primaryOwnerIndex};
        } else {
            firstSegmentOwners = new int[backupOwnerIndexes.length + 1];
            firstSegmentOwners[0] = primaryOwnerIndex;
            System.arraycopy(backupOwnerIndexes, 0, firstSegmentOwners, 1, backupOwnerIndexes.length);
        }
        return firstSegmentOwners;
    }

    public void setOwnerIndexes(int[][] segmentOwners) {
        this.ownerIndexes = (int[][])Arrays.stream(segmentOwners).map(owners -> Arrays.copyOf(owners, ((int[])owners).length)).toArray(x$0 -> new int[x$0][]);
    }

    public void triggerRebalance(Cache<?, ?> cache) {
        EmbeddedCacheManager cacheManager = cache.getCacheManager();
        AssertJUnit.assertTrue((String)"triggerRebalance must be called on the coordinator node", (boolean)TestingUtil.extractGlobalComponent((CacheContainer)cacheManager, Transport.class).isCoordinator());
        ClusterTopologyManager clusterTopologyManager = TestingUtil.extractGlobalComponent((CacheContainer)cacheManager, ClusterTopologyManager.class);
        clusterTopologyManager.forceRebalance(cache.getName());
    }

    @Override
    protected int[][] assignOwners(int numSegments, List<Address> members) {
        return (int[][])Arrays.stream(this.ownerIndexes).map(indexes -> this.mapOwnersToCurrentMembers(members, (int[])indexes)).toArray(x$0 -> new int[x$0][]);
    }

    private int[] mapOwnersToCurrentMembers(List<Address> members, int[] indexes) {
        int[] newIndexes = Arrays.stream(indexes).flatMap(index -> {
            if (this.membersToUse != null) {
                Address owner = this.membersToUse.get(index);
                int newIndex = members.indexOf(owner);
                if (newIndex >= 0) {
                    return IntStream.of(newIndex);
                }
            } else if (index < members.size()) {
                return IntStream.of(index);
            }
            return IntStream.empty();
        }).toArray();
        if (newIndexes.length == 0 && this.trait.requiresPrimaryOwner()) {
            return new int[]{0};
        }
        return newIndexes;
    }

    public void setMembersToUse(List<Address> membersToUse) {
        this.membersToUse = membersToUse;
    }

    public static class Externalizer
    extends AbstractExternalizer<ControlledConsistentHashFactory<?>> {
        public Set<Class<? extends ControlledConsistentHashFactory<?>>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Default.class, Replicated.class});
        }

        public void writeObject(ObjectOutput output, ControlledConsistentHashFactory<?> object) throws IOException {
            output.writeByte(object instanceof Default ? 0 : 1);
            int numOwners = object.ownerIndexes.length;
            MarshallUtil.marshallSize((DataOutput)output, (int)numOwners);
            for (int i = 0; i < numOwners; ++i) {
                int[] ownerSegments = object.ownerIndexes[i];
                MarshallUtil.marshallSize((DataOutput)output, (int)ownerSegments.length);
                for (int segment : ownerSegments) {
                    output.writeInt(segment);
                }
            }
            output.writeObject(object.membersToUse);
        }

        public ControlledConsistentHashFactory<?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte type = input.readByte();
            int numOwners = MarshallUtil.unmarshallSize((DataInput)input);
            int[][] indexes = new int[numOwners][];
            for (int i = 0; i < numOwners; ++i) {
                int numSegments = MarshallUtil.unmarshallSize((DataInput)input);
                int[] segments = new int[numSegments];
                for (int j = 0; j < numSegments; ++j) {
                    segments[j] = input.readInt();
                }
                indexes[i] = segments;
            }
            ControlledConsistentHashFactory chf = switch (type) {
                case 0 -> new Default(indexes);
                case 1 -> new Replicated(indexes[0]);
                default -> throw new IllegalStateException();
            };
            List membersToUse = (List)input.readObject();
            chf.setMembersToUse(membersToUse);
            return chf;
        }
    }

    @SerializeWith(value=Externalizer.class)
    public static class Replicated
    extends ControlledConsistentHashFactory<ReplicatedConsistentHash> {
        public Replicated(int primaryOwnerIndex) {
            super(new BaseControlledConsistentHashFactory.ReplicatedTrait(), primaryOwnerIndex, new int[0]);
        }

        /*
         * Exception decompiling
         */
        public Replicated(int[] segmentPrimaryOwners) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void setOwnerIndexes(int primaryOwnerIndex, int ... backupOwnerIndexes) {
            super.setOwnerIndexes(primaryOwnerIndex, new int[0]);
        }

        @Override
        public void setOwnerIndexes(int[][] segmentOwners) {
            super.setOwnerIndexes(segmentOwners);
        }

        private static /* synthetic */ int[][] lambda$new$1(int x$0) {
            return new int[x$0][];
        }
    }

    @SerializeWith(value=Externalizer.class)
    public static class Default
    extends ControlledConsistentHashFactory<DefaultConsistentHash> {
        public Default(int primaryOwnerIndex, int ... backupOwnerIndexes) {
            super(new BaseControlledConsistentHashFactory.DefaultTrait(), primaryOwnerIndex, backupOwnerIndexes);
        }

        public Default(int[][] segmentOwners) {
            super(new BaseControlledConsistentHashFactory.DefaultTrait(), segmentOwners);
        }
    }
}

