/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.impl.SingletonMapResponseCollector;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;

public abstract class AbstractDelegatingRpcManager
implements RpcManager {
    protected final RpcManager realOne;

    public AbstractDelegatingRpcManager(RpcManager realOne) {
        this.realOne = realOne;
    }

    public final <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        return this.performRequest(Collections.singleton(target), command, collector, c -> this.realOne.invokeCommand(target, command, c, rpcOptions), rpcOptions);
    }

    public final <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        return this.performRequest(targets, command, collector, c -> this.realOne.invokeCommand(targets, command, c, rpcOptions), rpcOptions);
    }

    public final <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        return this.performRequest(this.getTransport().getMembers(), command, collector, c -> this.realOne.invokeCommandOnAll(command, c, rpcOptions), rpcOptions);
    }

    public final <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        return this.performRequest(targets, command, collector, c -> this.realOne.invokeCommandStaggered(targets, command, c, rpcOptions), rpcOptions);
    }

    public final <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CommandsRequest<T> action = new CommandsRequest<T>(targets, collector);
        for (Address target : targets) {
            if (target.equals((Object)this.realOne.getAddress())) continue;
            this.invokeCommand(target, commandGenerator.apply(target), (ResponseCollector<T>)SingletonMapResponseCollector.ignoreLeavers(), rpcOptions).whenComplete(action);
        }
        return action.resultFuture;
    }

    public final <T> T blocking(CompletionStage<T> request) {
        return (T)this.realOne.blocking(request);
    }

    private void setTopologyId(ReplicableCommand command) {
        if (command instanceof TopologyAffectedCommand && ((TopologyAffectedCommand)command).getTopologyId() < 0) {
            ((TopologyAffectedCommand)command).setTopologyId(this.getTopologyId());
        }
    }

    public final void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        this.performSend(Collections.singleton(destination), command, c -> {
            this.realOne.sendTo(destination, command, deliverOrder);
            return null;
        });
    }

    public final void sendToMany(Collection<Address> destinations, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        List targets = destinations != null ? destinations : this.getTransport().getMembers();
        this.performSend(targets, command, c -> {
            this.realOne.sendToMany(destinations, command, deliverOrder);
            return null;
        });
    }

    public final void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        this.performSend(this.getTransport().getMembers(), command, c -> {
            this.realOne.sendToAll(command, deliverOrder);
            return null;
        });
    }

    public <O> XSiteResponse<O> invokeXSite(XSiteBackup backup, XSiteCacheRequest<O> command) {
        return this.realOne.invokeXSite(backup, command);
    }

    public Transport getTransport() {
        return this.realOne.getTransport();
    }

    public List<Address> getMembers() {
        return this.realOne.getMembers();
    }

    public Address getAddress() {
        return this.realOne.getAddress();
    }

    public int getTopologyId() {
        return this.realOne.getTopologyId();
    }

    public RpcOptions getSyncRpcOptions() {
        return this.realOne.getSyncRpcOptions();
    }

    public RpcOptions getTotalSyncRpcOptions() {
        return this.realOne.getTotalSyncRpcOptions();
    }

    protected <T> CompletionStage<T> performRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, Function<ResponseCollector<T>, CompletionStage<T>> invoker, RpcOptions rpcOptions) {
        return invoker.apply(collector);
    }

    protected <T> void performSend(Collection<Address> targets, ReplicableCommand command, Function<ResponseCollector<T>, CompletionStage<T>> invoker) {
        invoker.apply(null);
    }

    public static class CommandsRequest<T>
    implements BiConsumer<Map<Address, Response>, Throwable> {
        private final ResponseCollector<T> collector;
        CompletableFuture<T> resultFuture;
        int missingResponses;

        public CommandsRequest(Collection<Address> targets, ResponseCollector<T> collector) {
            this.collector = collector;
            this.resultFuture = new CompletableFuture();
            this.missingResponses = targets.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Map<Address, Response> responseMap, Throwable throwable) {
            boolean finish;
            Object result;
            CommandsRequest commandsRequest = this;
            synchronized (commandsRequest) {
                --this.missingResponses;
                if (this.resultFuture.isDone()) {
                    return;
                }
                try {
                    if (responseMap == null) {
                        return;
                    }
                    Map.Entry<Address, Response> singleResponse = responseMap.entrySet().iterator().next();
                    result = this.collector.addResponse(singleResponse.getKey(), singleResponse.getValue());
                }
                catch (Throwable t) {
                    this.resultFuture.completeExceptionally(t);
                    throw t;
                }
                finish = this.missingResponses == 0;
            }
            if (result != null) {
                this.resultFuture.complete(result);
            } else if (finish) {
                try {
                    this.resultFuture.complete(this.collector.finish());
                }
                catch (Throwable t) {
                    this.resultFuture.completeExceptionally(t);
                    throw t;
                }
            }
        }
    }
}

