/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.InDoubtTxInfo;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.PostCommitRecoveryStateTest")
public class PostCommitRecoveryStateTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(PostCommitRecoveryStateTest.class);

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configuration = PostCommitRecoveryStateTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        configuration.locking().useLockStriping(false).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().enable().clustering().stateTransfer().fetchInMemoryState(false);
        this.createCluster(configuration, 2);
        this.waitForClusterToForm();
        ComponentRegistry componentRegistry = ComponentRegistry.of(this.cache(0));
        XaTransactionTable txTable = (XaTransactionTable)componentRegistry.getComponent(TransactionTable.class);
        TestingUtil.replaceField(new RecoveryManagerDelegate(TestingUtil.extractComponent(this.cache(0), RecoveryManager.class)), "recoveryManager", txTable, XaTransactionTable.class);
    }

    public void testState() throws Exception {
        RecoveryManagerImpl rm1 = (RecoveryManagerImpl)ComponentRegistry.componentOf(this.advancedCache(1), RecoveryManager.class);
        TransactionTable tt1 = (TransactionTable)ComponentRegistry.componentOf(this.advancedCache(1), TransactionTable.class);
        AssertJUnit.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
        AssertJUnit.assertEquals((int)tt1.getRemoteTxCount(), (int)0);
        EmbeddedTransaction t0 = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        AssertJUnit.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
        AssertJUnit.assertEquals((int)tt1.getRemoteTxCount(), (int)0);
        RecoveryTestUtil.prepareTransaction(t0);
        AssertJUnit.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
        AssertJUnit.assertEquals((int)tt1.getRemoteTxCount(), (int)1);
        RecoveryTestUtil.commitTransaction(t0);
        AssertJUnit.assertEquals((int)tt1.getRemoteTxCount(), (int)1);
        AssertJUnit.assertEquals((int)rm1.getInDoubtTransactionsMap().size(), (int)0);
    }

    public static class RecoveryManagerDelegate
    implements RecoveryManager {
        volatile RecoveryManager rm;
        public boolean swallowRemoveRecoveryInfoCalls = true;

        public RecoveryManagerDelegate(RecoveryManager recoveryManager) {
            this.rm = recoveryManager;
        }

        public RecoveryManager.RecoveryIterator getPreparedTransactionsFromCluster() {
            return this.rm.getPreparedTransactionsFromCluster();
        }

        public CompletionStage<Void> removeRecoveryInformation(Collection<Address> where, XidImpl xid, GlobalTransaction gtx, boolean fromCluster) {
            if (this.swallowRemoveRecoveryInfoCalls) {
                log.trace((Object)"PostCommitRecoveryStateTest$RecoveryManagerDelegate.removeRecoveryInformation");
                return CompletableFutures.completedNull();
            }
            return this.rm.removeRecoveryInformation(where, xid, null, false);
        }

        public CompletionStage<Void> removeRecoveryInformationFromCluster(Collection<Address> where, long internalId) {
            return this.rm.removeRecoveryInformationFromCluster(where, internalId);
        }

        public RecoveryAwareTransaction removeRecoveryInformation(XidImpl xid) {
            this.rm.removeRecoveryInformation(xid);
            return null;
        }

        public void registerInDoubtTransaction(RecoveryAwareRemoteTransaction tx) {
            this.rm.registerInDoubtTransaction(tx);
        }

        public Set<InDoubtTxInfo> getInDoubtTransactionInfoFromCluster() {
            return this.rm.getInDoubtTransactionInfoFromCluster();
        }

        public Set<InDoubtTxInfo> getInDoubtTransactionInfo() {
            return this.rm.getInDoubtTransactionInfo();
        }

        public List<XidImpl> getInDoubtTransactions() {
            return this.rm.getInDoubtTransactions();
        }

        public RecoveryAwareTransaction getPreparedTransaction(XidImpl xid) {
            return this.rm.getPreparedTransaction(xid);
        }

        public CompletionStage<String> forceTransactionCompletion(XidImpl xid, boolean commit) {
            return this.rm.forceTransactionCompletion(xid, commit);
        }

        public String forceTransactionCompletionFromCluster(XidImpl xid, Address where, boolean commit) {
            return this.rm.forceTransactionCompletionFromCluster(xid, where, commit);
        }

        public boolean isTransactionPrepared(GlobalTransaction globalTx) {
            return this.rm.isTransactionPrepared(globalTx);
        }

        public RecoveryAwareTransaction removeRecoveryInformation(Long internalId) {
            this.rm.removeRecoveryInformation(internalId);
            return null;
        }
    }
}

