/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import javax.transaction.xa.Xid;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.InDoubtXidReturnedOnceTest")
public class InDoubtXidReturnedOnceTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configuration = InDoubtXidReturnedOnceTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        configuration.locking().useLockStriping(false).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().enable().clustering().stateTransfer().fetchInMemoryState(false).hash().numOwners(3);
        this.createCluster(configuration, 4);
        this.waitForClusterToForm();
    }

    public void testXidReturnedOnlyOnce() throws Throwable {
        EmbeddedTransaction tx = RecoveryTestUtil.beginAndSuspendTx(this.cache(3));
        RecoveryTestUtil.prepareTransaction(tx);
        this.manager(3).stop();
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0), this.cache(1), this.cache(2));
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(1), this.cache(2));
        EmbeddedTransaction tx2 = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        Xid[] recover = tx2.firstEnlistedResource().recover(0x1800000);
        AssertJUnit.assertEquals((int)recover.length, (int)1);
        AssertJUnit.assertEquals((Object)tx.getXid(), (Object)recover[0]);
    }
}

