/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import jakarta.transaction.SystemException;
import java.util.Collections;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.context.Flag;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractLocalTest
extends SingleCacheManagerTest {
    public void testPut() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k", (Object)"v");
        this.assertLocking();
    }

    public void testRemove() throws Exception {
        this.tm().begin();
        this.cache.remove((Object)"k");
        this.assertLocking();
    }

    public void testReplace() throws Exception {
        this.cache.put((Object)"k", (Object)"initial");
        this.tm().begin();
        this.cache.replace((Object)"k", (Object)"v");
        this.assertLocking();
    }

    public void testPutAll() throws Exception {
        Map<String, String> m = Collections.singletonMap("k", "v");
        this.tm().begin();
        this.cache.putAll(m);
        this.assertLocking();
    }

    public void testRollback() throws Exception {
        this.tm().begin();
        this.cache().put((Object)"k", (Object)"v");
        this.assertLockingOnRollback();
        Assert.assertNull((Object)this.cache().get((Object)"k"));
    }

    protected abstract void assertLockingOnRollback();

    protected abstract void assertLocking();

    protected void commit() {
        EmbeddedTransactionManager dtm = (EmbeddedTransactionManager)this.tm();
        try {
            dtm.firstEnlistedResource().commit((Xid)this.getXid(), true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepare() {
        EmbeddedTransactionManager dtm = (EmbeddedTransactionManager)this.tm();
        try {
            dtm.firstEnlistedResource().prepare((Xid)this.getXid());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void rollback() {
        EmbeddedTransactionManager dtm = (EmbeddedTransactionManager)this.tm();
        try {
            dtm.getTransaction().rollback();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private XidImpl getXid() throws SystemException {
        EmbeddedTransaction tx = (EmbeddedTransaction)this.tm().getTransaction();
        return tx.getXid();
    }

    public void testSizeAfterLocalClear() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).clear();
            AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        }
        finally {
            this.tm().commit();
        }
    }

    public void testEntrySetIsEmptyAfterLocalClear() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).clear();
            Assert.assertTrue((boolean)this.cache.entrySet().isEmpty());
        }
        finally {
            this.tm().commit();
        }
    }

    public void testEntrySetSizeAfterLocalClear() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).clear();
            AssertJUnit.assertEquals((int)0, (int)this.cache.entrySet().size());
        }
        finally {
            this.tm().commit();
        }
    }

    public void testKeySetIsEmptyAfterLocalClear() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).clear();
            Assert.assertTrue((boolean)this.cache.keySet().isEmpty());
        }
        finally {
            this.tm().commit();
        }
    }

    public void testKeySetSizeAfterLocalClear() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).clear();
            AssertJUnit.assertEquals((int)0, (int)this.cache.keySet().size());
        }
        finally {
            this.tm().commit();
        }
    }

    public void testValuesIsEmptyAfterLocalClear() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).clear();
            Assert.assertTrue((boolean)this.cache.values().isEmpty());
        }
        finally {
            this.tm().commit();
        }
    }

    public void testValuesSizeAfterLocalClear() throws Exception {
        this.cache.put((Object)1, (Object)"v1");
        this.tm().begin();
        try {
            this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).clear();
            AssertJUnit.assertEquals((int)0, (int)this.cache.values().size());
        }
        finally {
            this.tm().commit();
        }
    }
}

