/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.exception;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Collections;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="tx.exception.TxAndTimeoutExceptionTest", groups={"functional"})
public class TxAndTimeoutExceptionTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = this.getDefaultStandaloneCacheConfig(true);
        config.transaction().lockingMode(LockingMode.PESSIMISTIC).locking().useLockStriping(false).lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(config);
        this.cache = cm.getCache();
        return cm;
    }

    public void testPutTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(() -> this.cache.put((Object)"k1", (Object)"v2222"));
    }

    public void testRemoveTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(() -> this.cache.remove((Object)"k1"));
    }

    public void testReplaceTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(() -> this.cache.replace((Object)"k1", (Object)"newValue"));
    }

    public void testPutAllTimeoutsInTx() throws Exception {
        this.assertExpectedBehavior(() -> this.cache.putAll(Collections.singletonMap("k1", "v22222")));
    }

    private void assertExpectedBehavior(CacheOperation op) throws Exception {
        LockManager lm = TestingUtil.extractLockManager(this.cache);
        TransactionTable txTable = TestingUtil.getTransactionTable(this.cache);
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        Transaction k1LockOwner = tm.suspend();
        AssertJUnit.assertTrue((boolean)lm.isLocked((Object)"k1"));
        AssertJUnit.assertEquals((int)1, (int)txTable.getLocalTxCount());
        tm.begin();
        this.cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertTrue((boolean)lm.isLocked((Object)"k2"));
        AssertJUnit.assertEquals((int)2, (int)txTable.getLocalTxCount());
        AssertJUnit.assertNotNull((Object)tm.getTransaction());
        Exceptions.expectException(TimeoutException.class, op::execute);
        Transaction transaction = tm.getTransaction();
        AssertJUnit.assertNotNull((Object)transaction);
        AssertJUnit.assertEquals((int)1, (int)transaction.getStatus());
        AssertJUnit.assertTrue((boolean)lm.isLocked((Object)"k2"));
        AssertJUnit.assertTrue((boolean)lm.isLocked((Object)"k1"));
        Exceptions.expectException(CacheException.class, IllegalStateException.class, () -> this.cache.put((Object)"k3", (Object)"v3"));
        AssertJUnit.assertEquals((int)2, (int)txTable.getLocalTxCount());
        tm.rollback();
        AssertJUnit.assertEquals((int)1, (int)txTable.getLocalTxCount());
        tm.resume(k1LockOwner);
        tm.commit();
        AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTxCount());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
        AssertJUnit.assertFalse((boolean)lm.isLocked((Object)"k1"));
        AssertJUnit.assertFalse((boolean)lm.isLocked((Object)"k2"));
        AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTxCount());
    }

    public static interface CacheOperation {
        public void execute();
    }
}

