/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.TransactionManager;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TerminatedCacheWhileInTxTest")
public class TerminatedCacheWhileInTxTest
extends SingleCacheManagerTest {
    protected StorageType storage;

    @Factory
    public Object[] factory() {
        return new Object[]{new TerminatedCacheWhileInTxTest().withStorage(StorageType.BINARY), new TerminatedCacheWhileInTxTest().withStorage(StorageType.OBJECT), new TerminatedCacheWhileInTxTest().withStorage(StorageType.OFF_HEAP)};
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        c.transaction().cacheStopTimeout(10000L);
        c.memory().storageType(this.storage);
        return TestCacheManagerFactory.createCacheManager(c);
    }

    public TerminatedCacheWhileInTxTest withStorage(StorageType storage) {
        this.storage = storage;
        return this;
    }

    @Override
    protected String parameters() {
        return "[storage=" + String.valueOf(this.storage) + "]";
    }

    public void testNotAllowCallsWhileStopping(Method m) throws Throwable {
        this.cacheManager.defineConfiguration("cache-" + m.getName(), this.cacheManager.getDefaultCacheConfiguration());
        Cache cache1 = this.cacheManager.getCache("cache-" + m.getName());
        CyclicBarrier barrier = new CyclicBarrier(2);
        CountDownLatch latch = new CountDownLatch(1);
        TransactionManager tm = TestingUtil.getTransactionManager(cache1);
        Future<Void> waitAfterModFuture = this.fork(() -> {
            log.debug((Object)"Wait for all executions paths to be ready to perform calls.");
            tm.begin();
            cache1.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
            log.debug((Object)"Cache modified, wait for cache to be stopped.");
            barrier.await();
            AssertJUnit.assertFalse((boolean)latch.await(5L, TimeUnit.SECONDS));
            tm.commit();
            return null;
        });
        barrier.await();
        Future<Void> callStoppingCacheFuture = this.fork(() -> {
            log.debug((Object)"Wait very briefly and then make call.");
            Thread.sleep(2000L);
            cache1.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
            return null;
        });
        cache1.stop();
        latch.countDown();
        waitAfterModFuture.get();
        try {
            callStoppingCacheFuture.get();
            AssertJUnit.fail((String)"Should have thrown an IllegalLifecycleStateException");
        }
        catch (ExecutionException e) {
            AssertJUnit.assertTrue((String)e.toString(), (boolean)(e.getCause() instanceof IllegalLifecycleStateException));
        }
    }
}

