/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ParticipantFailsAfterPrepareTest")
@CleanupAfterMethod
public class ParticipantFailsAfterPrepareTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configuration = ParticipantFailsAfterPrepareTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        configuration.locking().useLockStriping(false).transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.OPTIMISTIC).useSynchronization(false).recovery().disable().clustering().stateTransfer().fetchInMemoryState(false).hash().numOwners(3);
        this.createCluster(TestDataSCI.INSTANCE, configuration, 4);
        this.waitForClusterToForm();
    }

    public void testNonOriginatorPrimaryFailsAfterPrepare() throws Exception {
        this.testNonOriginatorFailsAfterPrepare(1, 1);
    }

    public void testNonOriginatorBackupFailsAfterPrepare() throws Exception {
        this.testNonOriginatorFailsAfterPrepare(0, 2);
    }

    private void testNonOriginatorFailsAfterPrepare(int primaryOwnerIndex, int toKillIndex) throws Exception {
        Address originator = this.address(0);
        Address primaryOwner = this.address(primaryOwnerIndex);
        Address toKill = this.address(toKillIndex);
        MagicKey key = new MagicKey(this.cache(primaryOwnerIndex), this.cache(toKillIndex));
        Cache originatorCache = this.cache(0);
        DistributionManager dm0 = this.advancedCache(0).getDistributionManager();
        EmbeddedTransaction dummyTransaction = RecoveryTestUtil.beginAndSuspendTx(originatorCache, key);
        RecoveryTestUtil.prepareTransaction(dummyTransaction);
        log.debugf("Killing %s, key owners are %s", (Object)toKill, (Object)dm0.getCacheTopology().getWriteOwners((Object)key));
        this.killMember(toKillIndex);
        log.debugf("Killed %s, key owners are %s", (Object)toKill, (Object)dm0.getCacheTopology().getWriteOwners((Object)key));
        for (Cache c : this.caches()) {
            if (!this.address(c).equals((Object)originator)) {
                TransactionTable nonOwnerTxTable = TestingUtil.extractComponent(c, TransactionTable.class);
                AssertJUnit.assertEquals((int)1, (int)nonOwnerTxTable.getRemoteGlobalTransaction().size());
            }
            boolean expectLocked = this.address(c).equals((Object)primaryOwner);
            boolean locked = TestingUtil.extractLockManager(c).isLocked((Object)key);
            log.tracef("On %s, locked = %s", (Object)this.address(c), (Object)locked);
            AssertJUnit.assertEquals((boolean)expectLocked, (boolean)locked);
        }
        log.trace((Object)("About to commit. Killed node is: " + String.valueOf(toKill)));
        RecoveryTestUtil.commitTransaction(dummyTransaction);
        for (Cache c : this.caches()) {
            this.assertEventuallyNotLocked(c, key);
            AssertJUnit.assertEquals((int)1, (int)c.keySet().size());
        }
    }
}

