/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Sex;

public class Person
implements Serializable,
JsonSerialization,
Comparable {
    String name;
    Address address;
    byte[] picture;
    Sex sex;
    Date birthDate;
    boolean acceptedToS;
    double moneyOwned;
    float moneyOwed;
    double decimalField;
    float realField;

    public Person() {
    }

    public Person(String name) {
        this(name, null);
    }

    public Person(String name, Address address) {
        this(name, address, null, null, null, false, 1.1, 0.4f, 10.3, 4.7f);
    }

    @ProtoFactory
    public Person(String name, Address address, byte[] picture, Sex sex, Date birthDate, boolean acceptedToS, double moneyOwned, float moneyOwed, double decimalField, float realField) {
        this.name = name;
        this.address = address;
        this.picture = picture;
        this.sex = sex;
        this.birthDate = birthDate;
        this.acceptedToS = acceptedToS;
        this.moneyOwned = moneyOwned;
        this.moneyOwed = moneyOwed;
        this.decimalField = decimalField;
        this.realField = realField;
    }

    @ProtoField(value=1)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ProtoField(value=2)
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @ProtoField(value=3)
    public byte[] getPicture() {
        return this.picture;
    }

    public void setPicture(byte[] picture) {
        this.picture = picture;
    }

    @ProtoField(value=4)
    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    @ProtoField(value=5)
    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    @ProtoField(value=6, defaultValue="false", name="accepted_tos")
    public boolean isAcceptedToS() {
        return this.acceptedToS;
    }

    public void setAcceptedToS(boolean acceptedToS) {
        this.acceptedToS = acceptedToS;
    }

    @ProtoField(value=7, defaultValue="1.1")
    public double getMoneyOwned() {
        return this.moneyOwned;
    }

    public void setMoneyOwned(double moneyOwned) {
        this.moneyOwned = moneyOwned;
    }

    @ProtoField(value=8, defaultValue="0.4")
    public float getMoneyOwed() {
        return this.moneyOwed;
    }

    public void setMoneyOwed(float moneyOwed) {
        this.moneyOwed = moneyOwed;
    }

    @ProtoField(value=9, defaultValue="10.3")
    public double getDecimalField() {
        return this.decimalField;
    }

    public void setDecimalField(double decimalField) {
        this.decimalField = decimalField;
    }

    @ProtoField(value=10, defaultValue="4.7")
    public float getRealField() {
        return this.realField;
    }

    public void setRealField(float realField) {
        this.realField = realField;
    }

    public String toString() {
        return "Person{name='" + this.name + "', address=" + String.valueOf(this.address) + ", picture=" + Util.toHexString((byte[])this.picture) + ", sex=" + String.valueOf((Object)this.sex) + ", birthDate=" + String.valueOf(this.birthDate) + ", acceptedToS=" + this.acceptedToS + ", moneyOwned=" + this.moneyOwned + ", moneyOwed=" + this.moneyOwed + ", decimalField=" + this.decimalField + ", realField=" + this.realField + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.address != null ? !this.address.equals(person.address) : person.address != null) {
            return false;
        }
        return this.commonEquals(person);
    }

    private boolean commonEquals(Person person) {
        if (this.name != null ? !this.name.equals(person.name) : person.name != null) {
            return false;
        }
        if (this.picture != null ? !Arrays.equals(this.picture, person.picture) : person.picture != null) {
            return false;
        }
        if (this.sex != null ? !this.sex.equals((Object)person.sex) : person.sex != null) {
            return false;
        }
        if (this.birthDate != null ? !this.birthDate.equals(person.birthDate) : person.birthDate != null) {
            return false;
        }
        if (this.acceptedToS != person.acceptedToS) {
            return false;
        }
        if (this.moneyOwned != person.moneyOwned) {
            return false;
        }
        if (this.moneyOwed != person.moneyOwed) {
            return false;
        }
        if (this.decimalField != person.decimalField) {
            return false;
        }
        return this.realField == person.realField;
    }

    public boolean equalsIgnoreWhitespaceAddress(Person person) {
        if (this.address != null ? !this.address.equalsIgnoreStreetWhitespace(person.address) : person.address != null) {
            return false;
        }
        return this.commonEquals(person);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 29 * result + (this.picture != null ? Arrays.hashCode(this.picture) : 0);
        result = 29 * result + (this.sex != null ? this.sex.hashCode() : 0);
        result = 29 * result + (this.birthDate != null ? this.birthDate.hashCode() : 0);
        result = 29 * result + Boolean.hashCode(this.acceptedToS);
        result = 29 * result + Double.hashCode(this.moneyOwned);
        result = 29 * result + Float.hashCode(this.moneyOwed);
        result = 29 * result + Double.hashCode(this.decimalField);
        result = 29 * result + Float.hashCode(this.realField);
        return result;
    }

    public Json toJson() {
        return Json.object().set("name", (Object)this.name).set("address", Json.make((Object)this.address)).set("picture", (Object)this.picture).set("sex", (Object)this.sex).set("birthDate", (Object)(this.birthDate == null ? 0L : this.birthDate.getTime())).set("acceptedToS", (Object)this.acceptedToS).set("moneyOwned", (Object)this.moneyOwned).set("moneyOwed", (Object)Float.valueOf(this.moneyOwed)).set("decimalField", (Object)this.decimalField).set("realField", (Object)Float.valueOf(this.realField));
    }

    public int compareTo(Object o) {
        if (o instanceof Person) {
            Person o1 = (Person)o;
            return this.name.compareTo(o1.name);
        }
        throw new IllegalArgumentException("Person can't compate to " + String.valueOf(o.getClass()));
    }
}

