/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.infinispan.test.concurrent.DefaultInvocationMatcher;
import org.infinispan.test.concurrent.InvocationMatcher;
import org.infinispan.test.concurrent.StateInvocationMatcher;
import org.infinispan.test.concurrent.StateSequencer;

public class InvocationMatcherBuilder {
    private final String methodName;
    private Matcher instanceMatcher;
    private List<Matcher> argumentMatchers;
    private int matchCount = -1;
    private String inOrAfterState;
    private String afterState;
    private StateSequencer stateSequencer;

    public InvocationMatcherBuilder(String methodName) {
        this.methodName = methodName;
    }

    public InvocationMatcher build() {
        Matcher[] matchersArray = this.argumentMatchers != null ? this.argumentMatchers.toArray(new Matcher[this.argumentMatchers.size()]) : null;
        InvocationMatcher matcher = new DefaultInvocationMatcher(this.methodName, this.instanceMatcher, this.matchCount, matchersArray);
        if (this.inOrAfterState != null) {
            matcher = new StateInvocationMatcher(matcher, this.stateSequencer, StateInvocationMatcher.Relation.IN_OR_AFTER, this.inOrAfterState);
        }
        if (this.afterState != null) {
            matcher = new StateInvocationMatcher(matcher, this.stateSequencer, StateInvocationMatcher.Relation.AFTER, this.afterState);
        }
        return matcher;
    }

    public InvocationMatcherBuilder withParam(int index, Object expected) {
        Matcher matcher = CoreMatchers.equalTo((Object)expected);
        return this.withMatcher(index, matcher);
    }

    public InvocationMatcherBuilder withMatcher(int index, Matcher<?> matcher) {
        if (this.argumentMatchers == null) {
            this.argumentMatchers = new ArrayList<Matcher>(index + 1);
        }
        while (this.argumentMatchers.size() <= index) {
            this.argumentMatchers.add(null);
        }
        this.argumentMatchers.set(index, matcher);
        return this;
    }

    public InvocationMatcherBuilder matchCount(int matchCount) {
        this.matchCount = matchCount;
        return this;
    }

    public InvocationMatcherBuilder withThis(Matcher<Object> matcher) {
        this.instanceMatcher = matcher;
        return this;
    }

    public InvocationMatcherBuilder inOrAfterState(StateSequencer stateSequencer, String stateName) {
        assert (stateSequencer != null && (this.stateSequencer == null || this.stateSequencer == stateSequencer));
        this.stateSequencer = stateSequencer;
        this.inOrAfterState = stateName;
        return this;
    }

    public InvocationMatcherBuilder afterState(StateSequencer stateSequencer, String stateName) {
        assert (stateSequencer != null && (this.stateSequencer == null || this.stateSequencer == stateSequencer));
        this.stateSequencer = stateSequencer;
        this.afterState = stateName;
        return this;
    }
}

