/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.infinispan.test.concurrent.InvocationMatcher;

public class DefaultInvocationMatcher
implements InvocationMatcher {
    private final String methodName;
    private final Matcher instanceMatcher;
    private final Matcher[] argumentMatchers;
    private final int matchCount;
    private final AtomicInteger matches = new AtomicInteger();

    public DefaultInvocationMatcher(String methodName) {
        this(methodName, null, -1, null);
    }

    public DefaultInvocationMatcher(String methodName, Matcher instanceMatcher, int matchCount, Matcher ... argumentMatchers) {
        this.methodName = methodName;
        this.instanceMatcher = instanceMatcher;
        this.argumentMatchers = argumentMatchers;
        this.matchCount = matchCount;
    }

    @Override
    public boolean accept(Object instance, String methodName, Object[] arguments) {
        if (!methodName.equals(this.methodName)) {
            return false;
        }
        if (this.instanceMatcher != null && !this.instanceMatcher.matches(instance)) {
            return false;
        }
        if (this.argumentMatchers != null) {
            for (int i = 0; i < this.argumentMatchers.length; ++i) {
                if (this.argumentMatchers[i] == null || this.argumentMatchers[i].matches(arguments[i])) continue;
                return false;
            }
        }
        return this.matchCount < 0 || this.matches.getAndIncrement() == this.matchCount;
    }
}

