/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.Converter;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.stream.BaseSetupStreamIteratorTest;
import org.infinispan.stream.DistributedStreamIteratorWithPassivationTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.LocalStreamIteratorWithPassivationTest")
public class LocalStreamIteratorWithPassivationTest
extends DistributedStreamIteratorWithPassivationTest {
    protected ConfigurationBuilder builderUsed;

    public LocalStreamIteratorWithPassivationTest() {
        super(false, CacheMode.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(enabled=false, description="This requires supporting concurrent activation in cache loader interceptor")
    public void testConcurrentActivation() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache = this.cache(0, "testCache");
        HashMap<CallSite, String> originalValues = new HashMap<CallSite, String>();
        originalValues.put((CallSite)((Object)(cache.toString() + "1")), "cache0");
        originalValues.put((CallSite)((Object)(cache.toString() + "2")), "cache1");
        originalValues.put((CallSite)((Object)(cache.toString() + "3")), "cache2");
        String loaderKey = cache.toString() + " in loader";
        String loaderValue = "loader0";
        cache.putAll(originalValues);
        originalValues.put((CallSite)((Object)loaderKey), "loader0");
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache, PersistenceManager.class);
        DummyInMemoryStore store = (DummyInMemoryStore)persistenceManager.getStores(DummyInMemoryStore.class).iterator().next();
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        PersistenceManager pm = null;
        try {
            store.write(MarshalledEntryUtil.create(loaderKey, "loader0", (Marshaller)sm));
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((String)"loader0", (String)((String)cache.get((Object)loaderKey)));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Iterator iterator = cache.entrySet().stream().iterator();
            int count = 0;
            HashMap<String, String> results = new HashMap<String, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                results.put((String)entry.getKey(), (String)entry.getValue());
                ++count;
            }
            AssertJUnit.assertEquals((int)4, (int)count);
            AssertJUnit.assertEquals(originalValues, results);
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache, PersistenceManager.class, pm, true, true);
            }
            sm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(enabled=false, description="This requires supporting concurrent activation in cache loader interceptor")
    public void testConcurrentActivationWithFilter() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache = this.cache(0, "testCache");
        HashMap<CallSite, String> originalValues = new HashMap<CallSite, String>();
        originalValues.put((CallSite)((Object)(cache.toString() + "1")), "cache0");
        originalValues.put((CallSite)((Object)(cache.toString() + "2")), "cache1");
        originalValues.put((CallSite)((Object)(cache.toString() + "3")), "cache2");
        String loaderKey = cache.toString() + " in loader";
        String loaderValue = "loader0";
        String filteredLoaderKey = cache.toString() + " in loader1";
        String filteredLoaderValue = "loader1";
        cache.putAll(originalValues);
        originalValues.put((CallSite)((Object)loaderKey), "loader0");
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache, PersistenceManager.class);
        DummyInMemoryStore store = (DummyInMemoryStore)persistenceManager.getStores(DummyInMemoryStore.class).iterator().next();
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        PersistenceManager pm = null;
        try {
            store.write(MarshalledEntryUtil.create(loaderKey, "loader0", (Marshaller)sm));
            store.write(MarshalledEntryUtil.create(filteredLoaderKey, "loader1", (Marshaller)sm));
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((String)"loader0", (String)((String)cache.get((Object)loaderKey)));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Iterator iterator = cache.getAdvancedCache().cacheEntrySet().stream().filter(CacheFilters.predicate((k, v, m) -> originalValues.containsKey(k))).iterator();
            int count = 0;
            HashMap<String, String> results = new HashMap<String, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                results.put((String)entry.getKey(), (String)entry.getValue());
                ++count;
            }
            AssertJUnit.assertEquals((int)4, (int)count);
            AssertJUnit.assertEquals(originalValues, results);
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache, PersistenceManager.class, pm, true, true);
            }
            sm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(enabled=false, description="This requires supporting concurrent activation in cache loader interceptor")
    public void testConcurrentActivationWithConverter() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache = this.cache(0, "testCache");
        HashMap<CallSite, String> originalValues = new HashMap<CallSite, String>();
        originalValues.put((CallSite)((Object)(cache.toString() + "1")), "cache0");
        originalValues.put((CallSite)((Object)(cache.toString() + "2")), "cache1");
        originalValues.put((CallSite)((Object)(cache.toString() + "3")), "cache2");
        String loaderKey = cache.toString() + " in loader";
        String loaderValue = "loader0";
        cache.putAll(originalValues);
        originalValues.put((CallSite)((Object)loaderKey), "loader0");
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache, PersistenceManager.class);
        DummyInMemoryStore store = (DummyInMemoryStore)persistenceManager.getStores(DummyInMemoryStore.class).iterator().next();
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        PersistenceManager pm = null;
        try {
            store.write(MarshalledEntryUtil.create(loaderKey, "loader0", (Marshaller)sm));
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((String)"loader0", (String)((String)cache.get((Object)loaderKey)));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Iterator iterator = cache.getAdvancedCache().cacheEntrySet().stream().map(CacheFilters.function((Converter)new BaseSetupStreamIteratorTest.StringTruncator(1, 3))).iterator();
            int count = 0;
            HashMap<String, String> results = new HashMap<String, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                results.put((String)entry.getKey(), (String)entry.getValue());
                ++count;
            }
            AssertJUnit.assertEquals((int)4, (int)count);
            for (Map.Entry entry : originalValues.entrySet()) {
                AssertJUnit.assertEquals((String)((String)entry.getValue()).substring(1, 4), (String)((String)results.get(entry.getKey())));
            }
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache, PersistenceManager.class, pm, true, true);
            }
            sm.stop();
        }
    }

    @Override
    protected PersistenceManager waitUntilAboutToProcessStoreTask(Cache<?, ?> cache, CheckPoint checkPoint) {
        PersistenceManager pm = TestingUtil.extractComponent(cache, PersistenceManager.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)pm);
        PersistenceManager mockManager = (PersistenceManager)Mockito.mock(PersistenceManager.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((PersistenceManager)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("pre_process_on_all_stores_invoked");
            checkPoint.awaitStrict("pre_process_on_all_stores_released", 10L, TimeUnit.SECONDS);
            return forwardedAnswer.answer(invocation);
        }).when((Object)mockManager)).publishEntries((IntSet)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (Predicate)ArgumentMatchers.any());
        TestingUtil.replaceComponent(cache, PersistenceManager.class, mockManager, true);
        return pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConcurrentPassivation() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache = this.cache(0, "testCache");
        HashMap<CallSite, String> originalValues = new HashMap<CallSite, String>();
        originalValues.put((CallSite)((Object)(cache.toString() + "1")), "cache0");
        originalValues.put((CallSite)((Object)(cache.toString() + "2")), "cache1");
        originalValues.put((CallSite)((Object)(cache.toString() + "3")), "cache2");
        String loaderKey = cache.toString() + " loader-value";
        String loaderValue = "loader0";
        originalValues.put((CallSite)((Object)loaderKey), "loader0");
        cache.putAll(originalValues);
        PersistenceManager pm = null;
        try {
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                CompletionStages.join((CompletionStage)TestingUtil.extractComponent(cache, PassivationManager.class).passivateAsync((InternalCacheEntry)new ImmortalCacheEntry((Object)loaderKey, (Object)"loader0")));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Iterator iterator = cache.entrySet().stream().iterator();
            HashMap<String, String> results = new HashMap<String, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String prev = results.put((String)entry.getKey(), (String)entry.getValue());
                AssertJUnit.assertNull((String)("Entry " + String.valueOf(entry) + " replaced an existing value of " + prev), (Object)prev);
            }
            AssertJUnit.assertEquals(originalValues, results);
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache, PersistenceManager.class, pm, true, true);
            }
        }
    }
}

