/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.stream.StreamStoreAsBinarySerializationContextImpl;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.DistributedStreamIteratorWithStoreAsBinaryTest")
@InCacheMode(value={CacheMode.DIST_SYNC})
public class DistributedStreamIteratorWithStoreAsBinaryTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builderUsed = new ConfigurationBuilder();
        builderUsed.clustering().cacheMode(this.cacheMode);
        builderUsed.clustering().hash().numOwners(1);
        builderUsed.memory().storageType(StorageType.BINARY);
        this.createClusteredCaches(3, new StreamStoreAsBinarySerializationContextImpl(), builderUsed);
    }

    @Test
    public void testFilterWithStoreAsBinary() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        HashMap<MagicKey, String> originalValues = new HashMap<MagicKey, String>();
        originalValues.put(new MagicKey(cache0), "cache0");
        originalValues.put(new MagicKey(cache1), "cache1");
        originalValues.put(new MagicKey(cache2), "cache2");
        cache0.putAll(originalValues);
        Iterator iterator = cache1.getAdvancedCache().cacheEntrySet().stream().filter(CacheFilters.predicate((KeyValueFilter)new MagicKeyStringFilter(originalValues))).iterator();
        int count = 0;
        HashMap<MagicKey, String> results = new HashMap<MagicKey, String>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            results.put((MagicKey)entry.getKey(), (String)entry.getValue());
            ++count;
        }
        Assert.assertEquals((int)count, (int)3);
        Assert.assertEquals(originalValues, results);
    }

    @Test
    public void testFilterWithStoreAsBinaryPartialKeys() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        MagicKey findKey = new MagicKey(cache1);
        HashMap<MagicKey, String> originalValues = new HashMap<MagicKey, String>();
        originalValues.put(new MagicKey(cache0), "cache0");
        originalValues.put(findKey, "cache1");
        originalValues.put(new MagicKey(cache2), "cache2");
        cache0.putAll(originalValues);
        Iterator iterator = cache1.getAdvancedCache().cacheEntrySet().stream().filter(CacheFilters.predicate((KeyValueFilter)new MagicKeyStringFilter(Collections.singletonMap(findKey, "cache1")))).iterator();
        CacheEntry entry = (CacheEntry)iterator.next();
        AssertJUnit.assertEquals((Object)findKey, (Object)entry.getKey());
        AssertJUnit.assertEquals((String)"cache1", (String)((String)entry.getValue()));
        AssertJUnit.assertFalse((boolean)iterator.hasNext());
    }

    static class MagicKeyStringFilter
    implements KeyValueFilter<MagicKey, String> {
        Map<MagicKey, String> allowedEntries;

        MagicKeyStringFilter() {
        }

        MagicKeyStringFilter(Map<MagicKey, String> allowedEntries) {
            this.allowedEntries = allowedEntries;
        }

        @ProtoField(number=1, collectionImplementation=ArrayList.class)
        public List<MapPair> getMapEntries() {
            return this.allowedEntries.entrySet().stream().map(MapPair::new).collect(Collectors.toCollection(ArrayList::new));
        }

        public void setMapEntries(List<MapPair> entries) {
            this.allowedEntries = entries.stream().collect(Collectors.toMap(m -> m.key, m -> m.value));
        }

        public boolean accept(MagicKey key, String value, Metadata metadata) {
            String allowedValue = this.allowedEntries.get(key);
            return allowedValue != null && allowedValue.equals(value);
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={MagicKey.class, MagicKeyStringFilter.class, MapPair.class}, schemaFileName="core.stream.binary.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.stream.binary", service=false)
    static interface StreamStoreAsBinarySerializationContext
    extends SerializationContextInitializer {
    }

    static class MapPair {
        @ProtoField(value=1)
        MagicKey key;
        @ProtoField(value=2)
        String value;

        MapPair() {
        }

        MapPair(Map.Entry<MagicKey, String> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }
    }
}

