/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.MagicKey;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.CompositeKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.stream.BaseSetupStreamIteratorTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.BaseStreamIteratorTest")
public abstract class BaseStreamIteratorTest
extends BaseSetupStreamIteratorTest {
    public BaseStreamIteratorTest(boolean tx, CacheMode mode) {
        super(tx, mode);
    }

    protected abstract Object getKeyTiedToCache(Cache<?, ?> var1);

    protected Map<Object, String> putValuesInCache() {
        LinkedHashMap<Object, String> valuesInserted = new LinkedHashMap<Object, String>();
        Cache cache = this.cache(0, "testCache");
        Object key = this.getKeyTiedToCache(cache);
        cache.put(key, (Object)key.toString());
        valuesInserted.put(key, key.toString());
        return valuesInserted;
    }

    @AfterMethod
    public void removeInterceptor() {
        TestingUtil.extractInterceptorChain(this.advancedCache(0, "testCache")).removeInterceptor(AssertSkipCacheStoreInterceptor.class);
    }

    @Test
    public void simpleTest() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        CloseableIterator iterator = cache.entrySet().iterator();
        Map results = BaseStreamIteratorTest.mapFromIterator(iterator);
        AssertJUnit.assertEquals(values, results);
    }

    private void assertConversionEquals(Map<Object, String> map, CloseableIterator<? extends Map.Entry<MagicKey, byte[]>> iterator) {
        try (CloseableIterator<? extends Map.Entry<MagicKey, byte[]>> closeableIterator = iterator;){
            iterator.forEachRemaining(e -> {
                String val = (String)map.get(e.getKey());
                AssertJUnit.assertNotNull((String)("No value found for " + String.valueOf(e)), (Object)val);
                AssertJUnit.assertEquals((byte[])val.getBytes(StandardCharsets.UTF_8), (byte[])((byte[])e.getValue()));
            });
        }
    }

    @Test
    public void entrySetWithConversionTest() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        CloseableIterator iterator = cache.getAdvancedCache().withMediaType(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM).entrySet().iterator();
        this.assertConversionEquals(values, (CloseableIterator<? extends Map.Entry<MagicKey, byte[]>>)iterator);
    }

    @Test
    public void cacheEntrySetWithConversionTest() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        CloseableIterator iterator = cache.getAdvancedCache().withMediaType(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM).cacheEntrySet().iterator();
        this.assertConversionEquals(values, (CloseableIterator<? extends Map.Entry<MagicKey, byte[]>>)iterator);
    }

    @Test
    public void simpleTestIteratorWithMetadata() {
        HashSet<TransientMortalCacheEntry> valuesInserted = new HashSet<TransientMortalCacheEntry>();
        Cache cache = this.cache(0, "testCache");
        for (int i = 0; i < 3; ++i) {
            Object key = this.getKeyTiedToCache(cache);
            TimeUnit unit = TimeUnit.MINUTES;
            cache.put(key, (Object)key.toString(), 10L, unit, (long)(i + 1), unit);
            valuesInserted.add(new TransientMortalCacheEntry(key, (Object)key.toString(), unit.toMillis(i + 1), unit.toMillis(10L), System.currentTimeMillis()));
        }
        HashSet<CacheEntry> retrievedValues = new HashSet<CacheEntry>();
        for (CacheEntry entry : cache.getAdvancedCache().cacheEntrySet().stream()) {
            retrievedValues.add(entry);
        }
        AssertJUnit.assertEquals((int)retrievedValues.size(), (int)valuesInserted.size());
        for (CacheEntry cacheEntry : valuesInserted) {
            CacheEntry found = null;
            for (CacheEntry retrieved : retrievedValues) {
                if (!retrieved.getKey().equals(cacheEntry.getKey())) continue;
                found = retrieved;
                break;
            }
            AssertJUnit.assertNotNull((String)("No retrieved Value matching" + String.valueOf(cacheEntry)), found);
            AssertJUnit.assertEquals((String)((String)found.getValue()), (String)((String)cacheEntry.getValue()));
            AssertJUnit.assertEquals((long)found.getMaxIdle(), (long)cacheEntry.getMaxIdle());
            AssertJUnit.assertEquals((long)found.getLifespan(), (long)cacheEntry.getLifespan());
        }
    }

    @Test
    public void simpleTestLocalFilter() {
        Map<Object, String> values = this.putValuesInCache();
        Iterator<Map.Entry<Object, String>> iter = values.entrySet().iterator();
        Object excludedKey = iter.next().getKey();
        iter.remove();
        Cache cache = this.cache(0, "testCache");
        Iterator iterator = cache.getAdvancedCache().cacheEntrySet().stream().filter((SerializablePredicate & Serializable)entry -> !Objects.equals(excludedKey, entry.getKey())).iterator();
        Map results = BaseStreamIteratorTest.mapFromIterator(iterator);
        AssertJUnit.assertEquals(values, results);
    }

    @Test
    public void testFilterAndConverterCombined() {
        Map<Object, String> values = this.putValuesInCache();
        Iterator<Map.Entry<Object, String>> iter = values.entrySet().iterator();
        Object excludedKey = iter.next().getKey();
        iter.remove();
        Cache cache = this.cache(0, "testCache");
        KeyValueFilter filter = (KeyValueFilter & Serializable)(k, v, m) -> !Objects.equals(k, excludedKey);
        CompositeKeyValueFilterConverter<Object, String, String> filterConverter = new CompositeKeyValueFilterConverter<Object, String, String>(filter, new BaseSetupStreamIteratorTest.StringTruncator(2, 5));
        try (CacheStream stream = CacheFilters.filterAndConvert((CacheStream)cache.getAdvancedCache().cacheEntrySet().stream(), filterConverter);){
            Map results = BaseStreamIteratorTest.mapFromStream(stream);
            AssertJUnit.assertEquals((int)values.size(), (int)results.size());
            for (Map.Entry<Object, String> entry : values.entrySet()) {
                AssertJUnit.assertEquals((String)entry.getValue().substring(2, 7), (String)((String)results.get(entry.getKey())));
            }
        }
    }

    @Test
    public void testKeySetRemove() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TestingUtil.extractInterceptorChain(cache).addInterceptor((AsyncInterceptor)new AssertSkipCacheStoreInterceptor(), 0);
        CloseableIterator it = this.cache(0, "testCache").getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).keySet().iterator();
        while (it.hasNext()) {
            AssertJUnit.assertTrue((boolean)values.containsKey(it.next()));
            it.remove();
        }
        AssertJUnit.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testKeySetStreamRemove() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TestingUtil.extractInterceptorChain(cache).addInterceptor((AsyncInterceptor)new AssertSkipCacheStoreInterceptor(), 0);
        Iterator it = this.cache(0, "testCache").getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).keySet().stream().iterator();
        AssertJUnit.assertTrue((boolean)it.hasNext());
        AssertJUnit.assertTrue((boolean)values.containsKey(it.next()));
        Exceptions.expectException(UnsupportedOperationException.class, it::remove);
    }

    @Test
    public void testValuesRemove() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TestingUtil.extractInterceptorChain(cache).addInterceptor((AsyncInterceptor)new AssertSkipCacheStoreInterceptor(), 0);
        CloseableIterator it = this.cache(0, "testCache").getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).values().iterator();
        while (it.hasNext()) {
            AssertJUnit.assertTrue((boolean)values.containsValue(it.next()));
            it.remove();
        }
        AssertJUnit.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testValuesStreamRemove() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TestingUtil.extractInterceptorChain(cache).addInterceptor((AsyncInterceptor)new AssertSkipCacheStoreInterceptor(), 0);
        Iterator it = this.cache(0, "testCache").getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).values().stream().iterator();
        AssertJUnit.assertTrue((boolean)it.hasNext());
        AssertJUnit.assertTrue((boolean)values.containsValue(it.next()));
        Exceptions.expectException(UnsupportedOperationException.class, it::remove);
    }

    @Test
    public void testEntrySetRemove() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TestingUtil.extractInterceptorChain(cache).addInterceptor((AsyncInterceptor)new AssertSkipCacheStoreInterceptor(), 0);
        CloseableIterator it = this.cache(0, "testCache").getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            AssertJUnit.assertEquals((Object)values.get(key), entry.getValue());
            it.remove();
        }
        AssertJUnit.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testEntrySetStreamRemove() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TestingUtil.extractInterceptorChain(cache).addInterceptor((AsyncInterceptor)new AssertSkipCacheStoreInterceptor(), 0);
        Iterator it = this.cache(0, "testCache").getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).entrySet().stream().iterator();
        AssertJUnit.assertTrue((boolean)it.hasNext());
        Map.Entry entry = (Map.Entry)it.next();
        Object key = entry.getKey();
        AssertJUnit.assertEquals((Object)values.get(key), entry.getValue());
        Exceptions.expectException(UnsupportedOperationException.class, it::remove);
    }

    static class AssertSkipCacheStoreInterceptor
    extends DDAsyncInterceptor {
        AssertSkipCacheStoreInterceptor() {
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            AssertJUnit.assertTrue((boolean)command.hasAnyFlag(FlagBitSets.SKIP_CACHE_STORE));
            return super.visitRemoveCommand(ctx, command);
        }
    }
}

