/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.stream.BaseStreamIteratorTest;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.BaseClusteredStreamIteratorTest")
public abstract class BaseClusteredStreamIteratorTest
extends BaseStreamIteratorTest {
    public BaseClusteredStreamIteratorTest(boolean tx, CacheMode mode) {
        super(tx, mode);
    }

    @Override
    protected Map<Object, String> putValuesInCache() {
        return this.putValueInEachCache(3);
    }

    protected Map<Object, String> putValueInEachCache(int cacheNumber) {
        LinkedHashMap<Object, String> valuesInserted = new LinkedHashMap<Object, String>();
        for (int i = 0; i < cacheNumber; ++i) {
            Cache cache = this.cache(i, "testCache");
            Object key = this.getKeyTiedToCache(cache);
            cache.put(key, (Object)key.toString());
            valuesInserted.put(key, key.toString());
        }
        return valuesInserted;
    }

    @Test
    public void simpleTestIteratorFromOtherNode() {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(1, "testCache");
        Iterator iterator = cache.getAdvancedCache().cacheEntrySet().stream().iterator();
        Map results = BaseClusteredStreamIteratorTest.mapFromIterator(iterator);
        Assert.assertEquals(values, results);
    }

    @Test
    public void simpleTestRemoteFilter() {
        Map<Object, String> values = this.putValuesInCache();
        Iterator<Map.Entry<Object, String>> iter = values.entrySet().iterator();
        Object excludedKey = iter.next().getKey();
        iter.remove();
        Cache cache = this.cache(1, "testCache");
        Iterator iterator = cache.getAdvancedCache().cacheEntrySet().stream().filter((SerializablePredicate & Serializable)entry -> !Objects.equals(excludedKey, entry.getKey())).iterator();
        Map results = BaseClusteredStreamIteratorTest.mapFromIterator(iterator);
        Assert.assertEquals(results, values);
    }
}

