/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Value;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferLargeObjectTest")
public class StateTransferLargeObjectTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(StateTransferLargeObjectTest.class);
    private Cache<Integer, Object> c0;
    private Cache<Integer, Object> c1;
    private Cache<Integer, Object> c2;
    private Cache<Integer, Object> c3;
    private Map<Integer, Object> expected;
    private final Random rnd = new Random();

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).l1().disable().clustering().stateTransfer().fetchInMemoryState(true).locking().useLockStriping(false).clustering().hash().numOwners(3).numSegments(60).stateTransfer().chunkSize(50);
        this.createCluster(TestDataSCI.INSTANCE, builder, 4);
        this.c0 = this.cache(0);
        this.c1 = this.cache(1);
        this.c2 = this.cache(2);
        this.c3 = this.cache(3);
        this.waitForClusterToForm();
        log.debug((Object)"Rehash is complete!");
        this.expected = new HashMap<Integer, Object>();
    }

    public void testForFailure() {
        int i;
        int num = 500;
        for (i = 0; i < 500; ++i) {
            Object bigObject = this.createBigObject(i, "prefix");
            this.expected.put(i, bigObject);
            this.c0.put((Object)i, bigObject);
        }
        log.debug((Object)("About to stop " + String.valueOf(this.c3.getAdvancedCache().getRpcManager().getAddress())));
        this.c3.stop();
        this.c3.getCacheManager().stop();
        log.debug((Object)"Cache stopped async!");
        for (i = 0; i < 500; ++i) {
            log.debug((Object)("----Running a get on " + i));
            this.assertValue(i, this.c0.get((Object)i));
            this.assertValue(i, this.c1.get((Object)i));
            this.assertValue(i, this.c2.get((Object)i));
        }
        log.debug((Object)"Before stopping cache managers!");
        TestingUtil.killCacheManagers(this.manager(2));
        log.debug((Object)"2 killed");
        TestingUtil.killCacheManagers(this.manager(1));
        log.debug((Object)"1 killed");
        TestingUtil.killCacheManagers(this.manager(0));
        log.debug((Object)"0 killed");
    }

    private void assertValue(int i, Object o) {
        AssertJUnit.assertNotNull((Object)o);
        AssertJUnit.assertTrue((boolean)(o instanceof Value));
        AssertJUnit.assertEquals((Object)o, (Object)this.expected.get(i));
    }

    private Object createBigObject(int num, String prefix) {
        return new Value("[" + num + "|" + prefix + "|" + num * 3 + "|" + num * 7 + "]", this.generateLargeString());
    }

    private String generateLargeString() {
        byte[] bytes = new byte[2000];
        this.rnd.nextBytes(bytes);
        return new String(bytes);
    }

    @Override
    @AfterMethod
    protected void clearContent() {
    }
}

