/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.globalstate.NoOpGlobalConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.BlockingLocalTopologyManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.PutAllDuringJoinTest")
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC})
public class PutAllDuringJoinTest
extends MultipleCacheManagersTest {
    private static final int NUM_SEGMENTS = 6;
    private static final int NUM_KEYS = 18;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(2);
    }

    @Override
    protected void amendCacheManagerBeforeStart(EmbeddedCacheManager cm) {
        NoOpGlobalConfigurationManager.amendCacheManager(cm);
    }

    public void testPutMapDuringStateTransferWithEmptyCache() throws InterruptedException, ExecutionException, TimeoutException {
        this.doPutAllDuringStateTransfer(false);
    }

    public void testPutMapDuringStateTransferWithPopulatedCache() throws InterruptedException, ExecutionException, TimeoutException {
        this.doPutAllDuringStateTransfer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutAllDuringStateTransfer(boolean populateCache) throws InterruptedException, ExecutionException, TimeoutException {
        String cacheName = "c1-" + (!populateCache ? "empty-" : "") + this.cacheMode.toString().toLowerCase();
        Configuration config = PutAllDuringJoinTest.getDefaultClusteredCacheConfig(this.cacheMode).clustering().hash().numOwners(2).numSegments(6).build();
        this.manager(0).defineConfiguration(cacheName, config);
        TestingUtil.waitForNoRebalance(this.manager(0).getCache(cacheName));
        AssertJUnit.assertFalse((boolean)this.manager(1).cacheExists(cacheName));
        TreeMap dataMap = new TreeMap();
        if (populateCache) {
            IntStream.range(0, 18).forEach(num -> {
                dataMap.put(num, "value" + num);
                this.cache(0, cacheName).put((Object)num, (Object)"value");
            });
        } else {
            IntStream.range(0, 18).forEach(num -> dataMap.put(num, "value" + num));
        }
        BlockingLocalTopologyManager localTopologyManager0 = BlockingLocalTopologyManager.replaceTopologyManager(this.manager(0), cacheName);
        BlockingLocalTopologyManager localTopologyManager1 = BlockingLocalTopologyManager.replaceTopologyManager(this.manager(1), cacheName);
        this.manager(1).defineConfiguration(cacheName, config);
        Future<Cache> cacheStarted = this.fork(() -> this.manager(1).getCache(cacheName));
        BlockingLocalTopologyManager.confirmTopologyUpdate(CacheTopology.Phase.READ_OLD_WRITE_ALL, localTopologyManager0, localTopologyManager1);
        try {
            CacheTopology topology = localTopologyManager0.getCacheTopology(cacheName);
            for (int i = 0; i < 6; ++i) {
                AssertJUnit.assertEquals((int)1, (int)topology.getCurrentCH().locateOwnersForSegment(i).size());
                AssertJUnit.assertEquals((int)2, (int)topology.getPendingCH().locateOwnersForSegment(i).size());
            }
            this.cache(0, cacheName).putAll(dataMap);
            AssertJUnit.assertEquals((int)18, (int)this.cache(0, cacheName).size());
        }
        catch (Throwable throwable) {
            BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL, localTopologyManager0, localTopologyManager1);
            throw throwable;
        }
        BlockingLocalTopologyManager.finishRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL, localTopologyManager0, localTopologyManager1);
        cacheStarted.get(10L, TimeUnit.SECONDS);
    }
}

