/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.ClusterPermissionMapper;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.ClusterTopologyManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.DynamicRBACTest")
public class DynamicRBACTest
extends MultipleCacheManagersTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");
    static final Subject SUBJECT_A = TestingUtil.makeSubject("A");
    static final Subject SUBJECT_B = TestingUtil.makeSubject("B");
    private ClusterRoleMapper crm;
    private ClusterPermissionMapper cpm;

    @Override
    protected void createCacheManagers() throws Throwable {
        Security.doAs((Subject)ADMIN, () -> {
            this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder(), this.getConfigurationBuilder());
            this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder(), this.getConfigurationBuilder());
            this.waitForClusterToForm();
            this.crm = (ClusterRoleMapper)((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheManagerConfiguration().security().authorization().principalRoleMapper();
            this.crm.grant("admin", "admin");
            this.cpm = (ClusterPermissionMapper)((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheManagerConfiguration().security().authorization().rolePermissionMapper();
            FunctionalTestUtils.await(this.cpm.addRole(Role.newRole((String)"wizard", (String)"wizard role", (boolean)true, (boolean)true, (AuthorizationPermission[])new AuthorizationPermission[]{AuthorizationPermission.ALL_WRITE})));
            FunctionalTestUtils.await(this.cpm.addRole(Role.newRole((String)"cleric", (String)"cleric role", (boolean)false, (boolean)true, (AuthorizationPermission[])new AuthorizationPermission[]{AuthorizationPermission.ALL_READ})));
            return null;
        });
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        config.clustering().cacheMode(CacheMode.DIST_SYNC);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        authConfig.role("reader").role("writer").role("admin");
        return config;
    }

    private GlobalConfigurationBuilder getGlobalConfigurationBuilder() {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().groupOnlyMapping(false).principalRoleMapper((PrincipalRoleMapper)new ClusterRoleMapper()).rolePermissionMapper((RolePermissionMapper)new ClusterPermissionMapper());
        globalRoles.role("reader").permission(AuthorizationPermission.ALL_READ).role("writer").permission(AuthorizationPermission.ALL_WRITE).role("admin").permission(AuthorizationPermission.ALL);
        return global;
    }

    public void testClusterPrincipalMapper() {
        this.crm.grant("writer", "A");
        Security.doAs((Subject)SUBJECT_A, () -> {
            ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache().put((Object)"key", (Object)"value");
            return null;
        });
        this.crm.grant("reader", "B");
        Security.doAs((Subject)SUBJECT_B, () -> {
            AssertJUnit.assertEquals((Object)"value", (Object)((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache().get((Object)"key"));
            return null;
        });
    }

    public void testClusterPermissionMapper() {
        Map roles = this.cpm.getAllRoles();
        AssertJUnit.assertEquals((int)2, (int)roles.size());
        AssertJUnit.assertTrue((boolean)roles.containsKey("wizard"));
        Role wizard = (Role)roles.get("wizard");
        AssertJUnit.assertTrue((boolean)wizard.isImplicit());
        AssertJUnit.assertTrue((boolean)roles.containsKey("cleric"));
        Role cleric = (Role)roles.get("cleric");
        AssertJUnit.assertFalse((boolean)cleric.isImplicit());
        Cache cpmCache = (Cache)Security.doAs((Subject)ADMIN, () -> {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.security().authorization().enable().roles(new String[]{"admin", "wizard", "cleric"});
            return ((EmbeddedCacheManager)this.cacheManagers.get(0)).createCache("cpm", builder.build(((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheManagerConfiguration()));
        });
        Security.doAs((Subject)TestingUtil.makeSubject("wizard"), () -> {
            cpmCache.put((Object)"key", (Object)"value");
            return null;
        });
        Security.doAs((Subject)TestingUtil.makeSubject("cleric"), () -> {
            AssertJUnit.assertEquals((String)"value", (String)((String)cpmCache.get((Object)"key")));
            return null;
        });
        FunctionalTestUtils.await(this.cpm.removeRole("cleric"));
        roles = this.cpm.getAllRoles();
        AssertJUnit.assertEquals((int)1, (int)roles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoiner() {
        this.crm.grant("wizard", "gandalf");
        Cache crmCache = (Cache)TestingUtil.extractField(this.crm, "clusterRoleMap");
        ClusterTopologyManager crmTM = TestingUtil.extractComponent(crmCache, ClusterTopologyManager.class);
        crmTM.setRebalancingEnabled(false);
        FunctionalTestUtils.await(this.cpm.addRole(Role.newRole((String)"rogue", (String)"", (boolean)false, (boolean)true, (AuthorizationPermission[])new AuthorizationPermission[]{AuthorizationPermission.LISTEN})));
        Cache cpmCache = (Cache)TestingUtil.extractField(this.cpm, "clusterPermissionMap");
        ClusterTopologyManager cpmTM = TestingUtil.extractComponent(cpmCache, ClusterTopologyManager.class);
        cpmTM.setRebalancingEnabled(false);
        try {
            EmbeddedCacheManager joiner = (EmbeddedCacheManager)Security.doAs((Subject)ADMIN, () -> this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder(), this.getConfigurationBuilder(), new TransportFlags().withFD(true)));
            ClusterRoleMapper joinerCrm = (ClusterRoleMapper)Security.doAs((Subject)ADMIN, () -> (ClusterRoleMapper)joiner.getCacheManagerConfiguration().security().authorization().principalRoleMapper());
            TestingUtil.TestPrincipal gandalf = new TestingUtil.TestPrincipal("gandalf");
            AssertJUnit.assertTrue((boolean)this.crm.principalToRoles((Principal)gandalf).contains("wizard"));
            AssertJUnit.assertTrue((boolean)this.crm.list("gandalf").contains("wizard"));
            AssertJUnit.assertFalse((boolean)joinerCrm.principalToRoles((Principal)gandalf).contains("wizard"));
            AssertJUnit.assertFalse((boolean)joinerCrm.list("gandalf").contains("wizard"));
            ClusterPermissionMapper joinerCpm = (ClusterPermissionMapper)Security.doAs((Subject)ADMIN, () -> (ClusterPermissionMapper)joiner.getCacheManagerConfiguration().security().authorization().rolePermissionMapper());
            Role rogue0 = this.cpm.getRole("rogue");
            AssertJUnit.assertNotNull((Object)rogue0);
            Role rogue2 = joinerCpm.getRole("rogue");
            AssertJUnit.assertNull((Object)rogue2);
        }
        finally {
            crmTM.setRebalancingEnabled(true);
            cpmTM.setRebalancingEnabled(true);
        }
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        Security.doAs((Subject)ADMIN, () -> {
            DynamicRBACTest.super.destroy();
            return null;
        });
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> {
            this.cacheManagers.forEach(cm -> cm.getCache().clear());
            return null;
        });
    }
}

