/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.ClusteredSecureCacheTest")
public class ClusteredSecureCacheTest
extends MultipleCacheManagersTest {
    static final Subject ADMIN;
    static final Map<AuthorizationPermission, Subject> SUBJECTS;

    public CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ConfigurationBuilder builder = ClusteredSecureCacheTest.getDefaultClusteredCacheConfig(this.getCacheMode());
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            globalRoles.role(perm.toString()).permission(perm);
        }
        global.serialization().addAdvancedExternalizer(4321, (AdvancedExternalizer)new SecureConsumer.Externalizer());
        AuthorizationConfigurationBuilder authConfig = builder.security().authorization().enable();
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            authConfig.role(perm.toString());
        }
        Security.doAs((Subject)ADMIN, () -> {
            this.createCluster(global, builder, 2);
            this.waitForClusterToForm();
        });
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        Security.doAs((Subject)ADMIN, () -> ClusteredSecureCacheTest.super.destroy());
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        Security.doAs((Subject)ADMIN, () -> {
            try {
                ClusteredSecureCacheTest.super.clearContent();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void testClusteredSecureCache() {
        Security.doAs((Subject)ADMIN, () -> {
            Cache cache1 = this.cache(0);
            Cache cache2 = this.cache(1);
            cache1.put((Object)"a", (Object)"a");
            cache2.put((Object)"b", (Object)"b");
            AssertJUnit.assertEquals((String)"a", (String)((String)cache2.get((Object)"a")));
            AssertJUnit.assertEquals((String)"b", (String)((String)cache1.get((Object)"b")));
        });
    }

    public void testSecureClusteredExecutor() {
        ClusterExecutor executor = (ClusterExecutor)Security.doAs((Subject)SUBJECTS.get(AuthorizationPermission.EXEC), () -> this.manager(0).executor());
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            Subject subject = SUBJECTS.get(perm);
            Security.doAs((Subject)subject, () -> executor.allNodeSubmission().submitConsumer((Function)new SecureConsumer(), (a, v, t) -> {
                if (t != null) {
                    throw new RuntimeException((Throwable)t);
                }
                for (Principal principal : v.getPrincipals()) {
                    subject.getPrincipals().stream().filter(p -> p.getName().equals(principal.getName())).findFirst().orElseThrow();
                }
            }));
        }
    }

    static {
        SUBJECTS = TestingUtil.makeAllSubjects();
        ADMIN = SUBJECTS.get(AuthorizationPermission.ALL);
    }

    static class SecureConsumer
    implements Function<EmbeddedCacheManager, Subject>,
    Serializable {
        SecureConsumer() {
        }

        @Override
        public Subject apply(EmbeddedCacheManager m) {
            return Security.getSubject();
        }

        public static class Externalizer
        extends AbstractExternalizer<SecureConsumer> {
            public Set<Class<? extends SecureConsumer>> getTypeClasses() {
                return Collections.singleton(SecureConsumer.class);
            }

            public void writeObject(ObjectOutput output, SecureConsumer task) throws IOException {
            }

            public SecureConsumer readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new SecureConsumer();
            }
        }
    }
}

