/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHashFactory;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.jgroups.Address;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.rpc.RpcManagerTest")
public class RpcManagerTest
extends MultipleCacheManagersTest {
    private static final JGroupsAddress SUSPECT = new JGroupsAddress((Address)UUID.randomUUID());

    @Override
    protected void createCacheManagers() throws Throwable {
        NameCache.add((Address)SUSPECT.getJGroupsAddress(), (String)"SUSPECT");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.createCluster(builder, 3);
        this.waitForClusterToForm();
    }

    public void testInvokeCommand1() throws Exception {
        ClusteredGetCommand command = TestingUtil.extractCommandsFactory(this.cache(0)).buildClusteredGetCommand((Object)"key", Integer.valueOf(0), 0L);
        RpcManager rpcManager0 = this.cache(0).getAdvancedCache().getRpcManager();
        Exceptions.expectException(IllegalArgumentException.class, () -> rpcManager0.invokeCommand(this.address(0), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions()));
        command.setTopologyId(rpcManager0.getTopologyId());
        CompletionStage stage1 = rpcManager0.invokeCommand(this.address(0), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(null, stage1);
        CompletionStage stage2 = rpcManager0.invokeCommand(this.address(1), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE, stage2);
        CompletionStage stage3 = rpcManager0.invokeCommand((org.infinispan.remoting.transport.Address)SUSPECT, (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        Exceptions.expectExecutionException(SuspectException.class, stage3.toCompletableFuture());
    }

    public void testInvokeCommandCollection() throws Exception {
        ClusteredGetCommand command = TestingUtil.extractCommandsFactory(this.cache(0)).buildClusteredGetCommand((Object)"key", Integer.valueOf(0), 0L);
        RpcManager rpcManager0 = this.cache(0).getAdvancedCache().getRpcManager();
        Exceptions.expectException(IllegalArgumentException.class, () -> rpcManager0.invokeCommand(Arrays.asList(this.address(0)), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions()));
        command.setTopologyId(rpcManager0.getTopologyId());
        CompletionStage stage1 = rpcManager0.invokeCommand(Arrays.asList(this.address(0)), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(Collections.emptyMap(), stage1);
        CompletionStage stage2 = rpcManager0.invokeCommand(Arrays.asList(this.address(1)), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(Collections.singletonMap(this.address(1), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE), stage2);
        CompletionStage stage3 = rpcManager0.invokeCommand(Arrays.asList(this.address(0), this.address(1)), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(Collections.singletonMap(this.address(1), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE), stage3);
    }

    public void testInvokeCommandCollectionSuspect() throws Exception {
        ClusteredGetCommand command = TestingUtil.extractCommandsFactory(this.cache(0)).buildClusteredGetCommand((Object)"key", Integer.valueOf(0), 0L);
        RpcManager rpcManager0 = this.cache(0).getAdvancedCache().getRpcManager();
        command.setTopologyId(rpcManager0.getTopologyId());
        CompletionStage stage1 = rpcManager0.invokeCommand(Arrays.asList(SUSPECT), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        Exceptions.expectExecutionException(SuspectException.class, stage1.toCompletableFuture());
        CompletionStage stage2 = rpcManager0.invokeCommand(Arrays.asList(this.address(0), SUSPECT), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        Exceptions.expectExecutionException(SuspectException.class, stage2.toCompletableFuture());
        CompletionStage stage3 = rpcManager0.invokeCommand(Arrays.asList(this.address(0), this.address(1), SUSPECT), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        Exceptions.expectExecutionException(SuspectException.class, stage3.toCompletableFuture());
    }

    public void testInvokeCommandOnAll() throws Exception {
        ClusteredGetCommand command = TestingUtil.extractCommandsFactory(this.cache(0)).buildClusteredGetCommand((Object)"key", Integer.valueOf(0), 0L);
        RpcManager rpcManager0 = this.cache(0).getAdvancedCache().getRpcManager();
        Exceptions.expectException(IllegalArgumentException.class, () -> rpcManager0.invokeCommandOnAll((ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions()));
        command.setTopologyId(rpcManager0.getTopologyId());
        CompletionStage stage1 = rpcManager0.invokeCommandOnAll((ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(this.makeMap(this.address(1), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE, this.address(2), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE), stage1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeCommandOnAllSuspect() throws Exception {
        DistributionManager distributionManager = this.cache(0).getAdvancedCache().getDistributionManager();
        LocalizedCacheTopology initialTopology = distributionManager.getCacheTopology();
        AssertJUnit.assertEquals((Object)CacheTopology.Phase.NO_REBALANCE, (Object)initialTopology.getPhase());
        try {
            ClusteredGetCommand command = TestingUtil.extractCommandsFactory(this.cache(0)).buildClusteredGetCommand((Object)"key", Integer.valueOf(0), 0L);
            RpcManager rpcManager0 = this.cache(0).getAdvancedCache().getRpcManager();
            ArrayList<JGroupsAddress> newMembers = new ArrayList<JGroupsAddress>(initialTopology.getMembers());
            newMembers.add(SUSPECT);
            ReplicatedConsistentHash newCH = new ReplicatedConsistentHashFactory().create(1, 1, newMembers, null);
            CacheTopology suspectTopology = new CacheTopology(initialTopology.getTopologyId(), initialTopology.getRebalanceId(), (ConsistentHash)newCH, null, null, CacheTopology.Phase.NO_REBALANCE, newCH.getMembers(), null);
            distributionManager.setCacheTopology(suspectTopology);
            command.setTopologyId(rpcManager0.getTopologyId());
            CompletionStage stage1 = rpcManager0.invokeCommandOnAll((ReplicableCommand)command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
            Exceptions.expectExecutionException(SuspectException.class, stage1.toCompletableFuture());
        }
        finally {
            distributionManager.setCacheTopology((CacheTopology)initialTopology);
        }
    }

    public void testInvokeCommandStaggered() throws Exception {
        ClusteredGetCommand command = TestingUtil.extractCommandsFactory(this.cache(0)).buildClusteredGetCommand((Object)"key", Integer.valueOf(0), 0L);
        RpcManager rpcManager0 = this.cache(0).getAdvancedCache().getRpcManager();
        Exceptions.expectException(IllegalArgumentException.class, () -> rpcManager0.invokeCommandStaggered(Arrays.asList(this.address(0)), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions()));
        command.setTopologyId(rpcManager0.getTopologyId());
        CompletionStage stage1 = rpcManager0.invokeCommandStaggered(Arrays.asList(this.address(0)), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(null, stage1);
        CompletionStage stage2 = rpcManager0.invokeCommandStaggered(Arrays.asList(this.address(1)), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE, stage2);
        CompletionStage stage3 = rpcManager0.invokeCommandStaggered(Arrays.asList(this.address(0), this.address(1)), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE, stage3);
        CompletionStage stage4 = rpcManager0.invokeCommandStaggered(Arrays.asList(this.address(0), this.address(1), this.address(2)), (ReplicableCommand)command, (ResponseCollector)SingleResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE, stage4);
    }

    public void testInvokeCommands() throws Exception {
        ClusteredGetCommand command = TestingUtil.extractCommandsFactory(this.cache(0)).buildClusteredGetCommand((Object)"key", Integer.valueOf(0), 0L);
        RpcManager rpcManager0 = this.cache(0).getAdvancedCache().getRpcManager();
        Exceptions.expectException(IllegalArgumentException.class, () -> rpcManager0.invokeCommands(Arrays.asList(this.address(1)), a -> command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions()));
        command.setTopologyId(rpcManager0.getTopologyId());
        CompletionStage stage1 = rpcManager0.invokeCommands(Arrays.asList(this.address(0)), a -> command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(Collections.emptyMap(), stage1);
        CompletionStage stage2 = rpcManager0.invokeCommands(Arrays.asList(this.address(1)), a -> command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(Collections.singletonMap(this.address(1), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE), stage2);
        CompletionStage stage3 = rpcManager0.invokeCommands(Arrays.asList(this.address(0), this.address(1)), a -> command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(Collections.singletonMap(this.address(1), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE), stage3);
        CompletionStage stage4 = rpcManager0.invokeCommands(Arrays.asList(this.address(0), this.address(1), this.address(2)), a -> command, (ResponseCollector)MapResponseCollector.validOnly(), rpcManager0.getSyncRpcOptions());
        this.assertResponse(this.makeMap(this.address(1), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE, this.address(2), SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE), stage4);
    }

    private <T> void assertResponse(T expected, CompletionStage<T> stage2) {
        AssertJUnit.assertEquals(expected, stage2.toCompletableFuture().join());
    }

    private <T, U> Map<T, U> makeMap(T a1, U r1, T a2, U r2) {
        HashMap<T, U> map = new HashMap<T, U>();
        map.put(a1, r1);
        map.put(a2, r2);
        return map;
    }
}

