/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.Objects;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.xsite.commands.remote.XSiteRequest;

@Scope(value=Scopes.GLOBAL)
public class OffloadInboundInvocationHandler
implements InboundInvocationHandler {
    private final InboundInvocationHandler delegate;
    @Inject
    BlockingManager blockingManager;

    public static void replaceOn(EmbeddedCacheManager manager) {
        InboundInvocationHandler iih = TestingUtil.extractGlobalComponent((CacheContainer)manager, InboundInvocationHandler.class);
        if (iih instanceof OffloadInboundInvocationHandler) {
            return;
        }
        TestingUtil.wrapGlobalComponent((CacheContainer)manager, InboundInvocationHandler.class, OffloadInboundInvocationHandler::new, true);
    }

    private OffloadInboundInvocationHandler(InboundInvocationHandler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        this.blockingManager.runBlocking(() -> this.delegate.handleFromCluster(origin, command, reply, order), (Object)"offload-inbound-handler-cluster");
    }

    public void handleFromRemoteSite(String origin, XSiteRequest<?> command, Reply reply, DeliverOrder order) {
        this.blockingManager.runBlocking(() -> this.delegate.handleFromRemoteSite(origin, command, reply, order), (Object)"offload-inbound-handler-site");
    }
}

