/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.function.Predicate;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.NotifierLatch;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.xsite.commands.remote.XSiteRequest;

@Scope(value=Scopes.GLOBAL)
public class BlockingInboundInvocationHandler
implements InboundInvocationHandler {
    private final Address address;
    private final NotifierLatch latch;
    private final InboundInvocationHandler delegate;
    @Inject
    BlockingManager blockingManager;
    private volatile Predicate<ReplicableCommand> predicate;

    public static BlockingInboundInvocationHandler replace(EmbeddedCacheManager manager) {
        return TestingUtil.wrapGlobalComponent((CacheContainer)manager, InboundInvocationHandler.class, iih -> new BlockingInboundInvocationHandler((InboundInvocationHandler)iih, manager.getAddress()), true);
    }

    public BlockingInboundInvocationHandler(InboundInvocationHandler delegate, Address address) {
        this.delegate = delegate;
        this.address = address;
        this.latch = new NotifierLatch(this.toString());
    }

    public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        Predicate<ReplicableCommand> predicate = this.predicate;
        if (predicate != null && predicate.test(command)) {
            this.blockingManager.runBlocking(() -> {
                this.latch.blockIfNeeded();
                this.delegate.handleFromCluster(origin, command, reply, order);
            }, (Object)"blocking-inbound-handler");
            return;
        }
        this.delegate.handleFromCluster(origin, command, reply, order);
    }

    public void handleFromRemoteSite(String origin, XSiteRequest<?> command, Reply reply, DeliverOrder order) {
        this.delegate.handleFromRemoteSite(origin, command, reply, order);
    }

    public NotifierLatch latch() {
        return this.latch;
    }

    public <T extends ReplicableCommand> void blockBefore(Class<T> commandClass, Predicate<T> predicate) {
        this.predicate = c -> commandClass.isInstance(c) && predicate.test((ReplicableCommand)commandClass.cast(c));
        this.latch.startBlocking();
    }

    public void blockBefore(Class<? extends ReplicableCommand> commandClass) {
        this.predicate = commandClass::isInstance;
        this.latch.startBlocking();
    }

    public void stopBlocking() {
        this.latch.stopBlocking();
    }

    public String toString() {
        return "BlockingInboundInvocationHandler@" + String.valueOf(this.address);
    }
}

