/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.raft.RaftChannel;
import org.infinispan.remoting.transport.raft.RaftChannelConfiguration;
import org.infinispan.remoting.transport.raft.RaftManager;
import org.infinispan.remoting.transport.raft.RaftStateMachine;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.RaftTest")
public class RaftTest
extends MultipleCacheManagersTest {
    private static final RaftChannelConfiguration DEFAULT_CONFIGURATION = new RaftChannelConfiguration.Builder().logMode(RaftChannelConfiguration.RaftLogMode.VOLATILE).build();
    private static final int CONCURRENT_THREADS = 16;
    private static final int CLUSTER_SIZE = 3;
    private static final String[] RAFT_MEMBERS = new String[]{"RaftTest-A", "RaftTest-B", "RaftTest-C", "RaftTest-D"};

    @Override
    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 3; ++i) {
            GlobalConfigurationBuilder builder = this.defaultGlobalConfigurationBuilder();
            builder.transport().raftMembers(RAFT_MEMBERS);
            builder.transport().nodeName(RAFT_MEMBERS[i]);
            this.addClusterEnabledCacheManager(builder, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testRaft(Method method) throws ExecutionException, InterruptedException, TimeoutException {
        void var7_11;
        List<RaftManager> raftManagerList = this.raftManagers();
        for (RaftManager m : raftManagerList) {
            AssertJUnit.assertTrue((boolean)m.isRaftAvailable());
        }
        List<RaftQueueStateMachine> stateMachines = RaftTest.registerStateMachine(raftManagerList, RaftQueueStateMachine::new, method.getName());
        RaftTest.awaitForLeader(raftManagerList, method.getName());
        ArrayList<Future<CompletionStage>> futures = new ArrayList<Future<CompletionStage>>(16);
        CyclicBarrier barrier = new CyclicBarrier(16);
        for (int i = 0; i < 16; ++i) {
            int n = i % stateMachines.size();
            byte b = (byte)i;
            futures.add(this.fork(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                return ((RaftQueueStateMachine)stateMachines.get((int)idx)).raftChannel.send((ByteBuffer)ByteBufferImpl.create((byte)b));
            }));
        }
        for (Future future : futures) {
            CompletionStage cf = (CompletionStage)future.get(10L, TimeUnit.SECONDS);
            ByteBuffer buffer = (ByteBuffer)cf.toCompletableFuture().get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((int)1, (int)buffer.getLength());
            AssertJUnit.assertEquals((int)0, (int)buffer.getBuf()[0]);
        }
        ArrayList<Byte> expectedState = null;
        boolean bl = false;
        while (var7_11 < stateMachines.size()) {
            RaftQueueStateMachine m = stateMachines.get((int)var7_11);
            RaftTest.eventually(() -> m.state.size() == 16);
            if (expectedState == null) {
                expectedState = new ArrayList<Byte>(m.state);
            } else {
                AssertJUnit.assertEquals((String)("State is different for node " + (int)var7_11), expectedState, m.state);
            }
            ++var7_11;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testRaftStateTransfer(Method method) throws ExecutionException, InterruptedException, TimeoutException {
        void var7_11;
        List<RaftManager> raftManagerList = this.raftManagers();
        for (RaftManager m : raftManagerList) {
            AssertJUnit.assertTrue((boolean)m.isRaftAvailable());
        }
        List<RaftQueueStateMachine> stateMachines = RaftTest.registerStateMachine(raftManagerList, RaftQueueStateMachine::new, method.getName());
        RaftTest.awaitForLeader(raftManagerList, method.getName());
        ArrayList<Future<CompletionStage>> futures = new ArrayList<Future<CompletionStage>>(16);
        CyclicBarrier barrier = new CyclicBarrier(16);
        for (int i = 0; i < 16; ++i) {
            int n = i % stateMachines.size();
            byte b = (byte)i;
            futures.add(this.fork(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                return ((RaftQueueStateMachine)stateMachines.get((int)idx)).raftChannel.send((ByteBuffer)ByteBufferImpl.create((byte)b));
            }));
        }
        for (Future future : futures) {
            CompletionStage cf = (CompletionStage)future.get(10L, TimeUnit.SECONDS);
            ByteBuffer buffer = (ByteBuffer)cf.toCompletableFuture().get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((int)1, (int)buffer.getLength());
            AssertJUnit.assertEquals((int)0, (int)buffer.getBuf()[0]);
        }
        ArrayList<Byte> expectedState = null;
        boolean bl = false;
        while (var7_11 < stateMachines.size()) {
            RaftQueueStateMachine m = stateMachines.get((int)var7_11);
            RaftTest.eventually(() -> m.state.size() == 16);
            if (expectedState == null) {
                expectedState = new ArrayList<Byte>(m.state);
            } else {
                AssertJUnit.assertEquals((String)("State is different for node " + (int)var7_11), expectedState, m.state);
            }
            ++var7_11;
        }
        try {
            GlobalConfigurationBuilder globalConfigurationBuilder = this.defaultGlobalConfigurationBuilder();
            globalConfigurationBuilder.transport().raftMembers(RAFT_MEMBERS);
            globalConfigurationBuilder.transport().nodeName(RAFT_MEMBERS[3]);
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(globalConfigurationBuilder, null);
            RaftManager raftManager = RaftTest.raftManager(cm);
            RaftQueueStateMachine sm = RaftTest.registerStateMachine(raftManager, RaftQueueStateMachine::new, method.getName());
            RaftTest.awaitForLeader(raftManager, method.getName());
            this.eventuallyEquals(16, sm.state::size);
            AssertJUnit.assertEquals((String)"State is different for node 3", expectedState, sm.state);
            if (this.cacheManagers.size() != 4) return;
        }
        catch (Throwable throwable) {
            if (this.cacheManagers.size() != 4) throw throwable;
            TestingUtil.killCacheManagers((EmbeddedCacheManager)this.cacheManagers.remove(3));
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager)this.cacheManagers.remove(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testNoDupes(Method method) throws ExecutionException, InterruptedException, TimeoutException {
        void var7_11;
        List<RaftManager> raftManagerList = this.raftManagers();
        for (RaftManager m : raftManagerList) {
            AssertJUnit.assertTrue((boolean)m.isRaftAvailable());
        }
        List<RaftQueueStateMachine> stateMachines = RaftTest.registerStateMachine(raftManagerList, RaftQueueStateMachine::new, method.getName());
        RaftTest.awaitForLeader(raftManagerList, method.getName());
        ArrayList<Future<CompletionStage>> futures = new ArrayList<Future<CompletionStage>>(16);
        CyclicBarrier barrier = new CyclicBarrier(16);
        for (int i = 0; i < 16; ++i) {
            int n = i % stateMachines.size();
            byte b = (byte)i;
            futures.add(this.fork(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                return ((RaftQueueStateMachine)stateMachines.get((int)idx)).raftChannel.send((ByteBuffer)ByteBufferImpl.create((byte)b));
            }));
        }
        for (Future future : futures) {
            CompletionStage cf = (CompletionStage)future.get(10L, TimeUnit.SECONDS);
            ByteBuffer buffer = (ByteBuffer)cf.toCompletableFuture().get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((int)1, (int)buffer.getLength());
            AssertJUnit.assertEquals((int)0, (int)buffer.getBuf()[0]);
        }
        ArrayList<Byte> expectedState = null;
        boolean bl = false;
        while (var7_11 < stateMachines.size()) {
            RaftQueueStateMachine m = stateMachines.get((int)var7_11);
            RaftTest.eventually(() -> m.state.size() == 16);
            if (expectedState == null) {
                expectedState = new ArrayList<Byte>(m.state);
            } else {
                AssertJUnit.assertEquals((String)("State is different for node " + (int)var7_11), expectedState, m.state);
            }
            ++var7_11;
        }
        try {
            GlobalConfigurationBuilder globalConfigurationBuilder = this.defaultGlobalConfigurationBuilder();
            globalConfigurationBuilder.transport().raftMembers(RAFT_MEMBERS);
            globalConfigurationBuilder.transport().nodeName(RAFT_MEMBERS[2]);
            Exceptions.expectException(EmbeddedCacheManagerStartupException.class, CacheException.class, SecurityException.class, () -> this.addClusterEnabledCacheManager(globalConfigurationBuilder, null));
            if (this.cacheManagers.size() != 4) return;
        }
        catch (Throwable throwable) {
            if (this.cacheManagers.size() != 4) throw throwable;
            TestingUtil.killCacheManagers((EmbeddedCacheManager)this.cacheManagers.remove(3));
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager)this.cacheManagers.remove(3));
    }

    private List<RaftManager> raftManagers() {
        return this.cacheManagers.stream().map(RaftTest::raftManager).collect(Collectors.toList());
    }

    private static RaftManager raftManager(EmbeddedCacheManager cacheManager) {
        return TestingUtil.extractGlobalComponent((CacheContainer)cacheManager, Transport.class).raftManager();
    }

    private static <T extends RaftStateMachine> List<T> registerStateMachine(List<? extends RaftManager> raftManagers, Supplier<? extends T> supplier, String name) {
        return raftManagers.stream().map(m -> RaftTest.registerStateMachine(m, supplier, name)).collect(Collectors.toList());
    }

    private static <T extends RaftStateMachine> T registerStateMachine(RaftManager manager, Supplier<T> supplier, String name) {
        return (T)manager.getOrRegisterStateMachine(name, supplier, DEFAULT_CONFIGURATION);
    }

    private static void awaitForLeader(List<? extends RaftManager> raftManagers, String name) {
        for (RaftManager raftManager : raftManagers) {
            RaftTest.awaitForLeader(raftManager, name);
        }
    }

    private static void awaitForLeader(RaftManager manager, String name) {
        RaftTest.eventually(() -> manager.hasLeader(name));
    }

    private static class RaftQueueStateMachine
    implements RaftStateMachine {
        private volatile RaftChannel raftChannel;
        final List<Byte> state = Collections.synchronizedList(new LinkedList());

        private RaftQueueStateMachine() {
        }

        public void init(RaftChannel raftChannel) {
            this.raftChannel = raftChannel;
        }

        public ByteBuffer apply(ByteBuffer buffer) throws Exception {
            AssertJUnit.assertEquals((int)1, (int)buffer.getLength());
            this.state.add(buffer.getBuf()[0]);
            log.debugf("[%s | %s] apply: %d", (Object)this.raftChannel.channelName(), (Object)this.raftChannel.raftId(), (Object)this.state.size());
            return ByteBufferImpl.create((byte)0);
        }

        public void readStateFrom(DataInput dataInput) throws IOException {
            int size = dataInput.readInt();
            this.state.clear();
            for (int i = 0; i < size; ++i) {
                this.state.add(dataInput.readByte());
            }
            log.debugf("[%s | %s] received state: %d", (Object)this.raftChannel.channelName(), (Object)this.raftChannel.raftId(), (Object)this.state.size());
        }

        public void writeStateTo(DataOutput dataOutput) throws IOException {
            ArrayList<Byte> copy = new ArrayList<Byte>(this.state);
            dataOutput.writeInt(copy.size());
            Iterator iterator = copy.iterator();
            while (iterator.hasNext()) {
                byte b = (Byte)iterator.next();
                dataOutput.writeByte(b);
            }
            log.debugf("[%s | %s] sent state: %d", (Object)this.raftChannel.channelName(), (Object)this.raftChannel.raftId(), (Object)copy.size());
        }
    }
}

