/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.sifs.SoftIndexFileStoreDistFourNodeTest")
public class SoftIndexFileStoreDistFourNodeTest
extends MultipleCacheManagersTest {
    private static final int CLUSTER_SIZE = 4;
    private static final String CACHE_NAME = "testCache";

    @Override
    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 4; ++i) {
            this.createStatefulCacheManager("A" + i);
        }
    }

    private void createStatefulCacheManager(String id) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id});
        Util.recursiveFileRemove((String)stateDirectory);
        GlobalConfigurationBuilder global = this.defaultGlobalConfigurationBuilder();
        global.globalState().enabled(true).configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(stateDirectory);
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.clustering().cacheMode(CacheMode.DIST_SYNC);
        config.persistence().addSoftIndexFileStore().dataLocation(Paths.get(stateDirectory, "data").toString()).indexLocation(Paths.get(stateDirectory, "index").toString());
        EmbeddedCacheManager manager = this.addClusterEnabledCacheManager(global, null);
        manager.defineConfiguration(CACHE_NAME, config.build());
        this.waitForClusterToForm(CACHE_NAME);
    }

    public void testLargeClusterSize() {
        for (int i = 0; i < 4; ++i) {
            Assertions.assertThat((int)this.cache(i, CACHE_NAME).size()).isZero();
        }
    }
}

