/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.WriteSkewCacheLoaderFunctionalTest")
public class WriteSkewCacheLoaderFunctionalTest
extends SingleCacheManagerTest {
    DummyInMemoryStore loader;
    static final long LIFESPAN = 60000000L;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.defineConfiguration();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(builder);
        this.loader = (DummyInMemoryStore)TestingUtil.getFirstStore(cm.getCache());
        return cm;
    }

    private ConfigurationBuilder defineConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).clustering().cacheMode(CacheMode.REPL_SYNC).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.getClass().getName()).preload(true);
        return builder;
    }

    private void assertInCacheAndStore(Cache cache, DummyInMemoryStore loader, Object key, Object value) throws PersistenceException {
        this.assertInCacheAndStore(cache, loader, key, value, -1L);
    }

    private void assertInCacheAndStore(Cache cache, DummyInMemoryStore store, Object key, Object value, long lifespanMillis) throws PersistenceException {
        InternalCacheValue icv = cache.getAdvancedCache().getDataContainer().peek(key).toInternalCacheValue();
        this.assertStoredEntry(icv.getValue(), value, icv.getLifespan(), lifespanMillis, "Cache", key);
        AssertJUnit.assertNotNull((String)("For :" + String.valueOf(icv)), (Object)icv.getInternalMetadata().entryVersion());
        MarshallableEntry load = store.loadEntry(key);
        this.assertStoredEntry(load.getValue(), value, load.getMetadata() == null ? -1L : load.getMetadata().lifespan(), lifespanMillis, "Store", key);
        AssertJUnit.assertNotNull((String)("For :" + String.valueOf(load)), (Object)load.getInternalMetadata().entryVersion());
    }

    private void assertStoredEntry(Object value, Object expectedValue, long lifespanMillis, long expectedLifespan, String src, Object key) {
        AssertJUnit.assertNotNull((String)(src + " entry for key " + String.valueOf(key) + " should NOT be null"), (Object)value);
        AssertJUnit.assertEquals((String)(src + " should contain value " + String.valueOf(expectedValue) + " under key " + String.valueOf(key) + " but was " + String.valueOf(value)), (Object)expectedValue, (Object)value);
        AssertJUnit.assertEquals((String)(src + " expected lifespan for key " + String.valueOf(key) + " to be " + expectedLifespan + " but was " + lifespanMillis), (long)expectedLifespan, (long)lifespanMillis);
    }

    private <T> void assertNotInCacheAndStore(Cache cache, DummyInMemoryStore store, Collection<T> keys) throws PersistenceException {
        for (T key : keys) {
            AssertJUnit.assertFalse((String)("Cache should not contain key " + String.valueOf(key)), (boolean)cache.getAdvancedCache().getDataContainer().containsKey(key));
            AssertJUnit.assertFalse((String)("Store should not contain key " + String.valueOf(key)), (boolean)store.contains(key));
        }
    }

    public void testPreloadingInTransactionalCache() throws Exception {
        AssertJUnit.assertTrue((boolean)this.cache.getCacheConfiguration().persistence().preload());
        this.assertNotInCacheAndStore(this.cache, this.loader, Arrays.asList("k1", "k2", "k3", "k4"));
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", 60000000L, TimeUnit.MILLISECONDS);
        this.cache.put((Object)"k3", (Object)"v3");
        this.cache.put((Object)"k4", (Object)"v4", 60000000L, TimeUnit.MILLISECONDS);
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(this.cache, this.loader, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(this.cache, this.loader, "k" + i, "v" + i, 60000000L);
        }
        DataContainer c = this.cache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((int)4, (int)c.size());
        this.cache.stop();
        AssertJUnit.assertEquals((int)0, (int)c.size());
        this.cache.start();
        AssertJUnit.assertTrue((boolean)this.cache.getCacheConfiguration().persistence().preload());
        c = this.cache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((int)4, (int)c.size());
        this.loader = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(this.cache, this.loader, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(this.cache, this.loader, "k" + i, "v" + i, 60000000L);
        }
        TestingUtil.withTx(this.cache.getAdvancedCache().getTransactionManager(), () -> {
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
            this.cache.put((Object)"k1", (Object)"new-v1");
            return null;
        });
    }
}

