/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.SharedStoreTest", groups={"functional"})
@CleanupAfterMethod
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC})
public class SharedStoreTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(SharedStoreTest.class.getName()).purgeOnStartup(false)).shared(true)).clustering().cacheMode(this.cacheMode).build();
        this.createCluster(cfg, 3);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
        List<DummyInMemoryStore<String, String>> cachestores = TestingUtil.cachestores(this.caches());
        super.clearContent();
        this.clearStoreStats(cachestores);
    }

    private void clearStoreStats(List<DummyInMemoryStore<String, String>> cachestores) {
        cachestores.forEach(DummyInMemoryStore::clearStats);
    }

    public void testUnnecessaryWrites() throws PersistenceException {
        this.cache(0).put((Object)"key", (Object)"value");
        for (Cache c : this.caches()) {
            AssertJUnit.assertEquals((Object)"value", (Object)c.get((Object)"key"));
        }
        List cacheStores = TestingUtil.cachestores(this.caches());
        for (DummyInMemoryStore dummyInMemoryStore : cacheStores) {
            AssertJUnit.assertTrue((boolean)dummyInMemoryStore.contains("key"));
            AssertJUnit.assertEquals((int)0, (int)dummyInMemoryStore.stats().get("clear"));
            AssertJUnit.assertEquals((int)0, (int)dummyInMemoryStore.stats().get("clear"));
            AssertJUnit.assertEquals((int)1, (int)dummyInMemoryStore.stats().get("write"));
        }
        this.cache(0).remove((Object)"key");
        for (Cache cache : this.caches()) {
            AssertJUnit.assertNull((Object)cache.get((Object)"key"));
        }
        for (DummyInMemoryStore dummyInMemoryStore : cacheStores) {
            assert (!dummyInMemoryStore.contains("key"));
            AssertJUnit.assertEquals((String)"Entry should have been removed from the cache store just once", (Object)1, (Object)dummyInMemoryStore.stats().get("delete"));
        }
    }

    public void testSkipSharedCacheStoreFlagUsage() throws PersistenceException {
        this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_SHARED_CACHE_STORE).put((Object)"key", (Object)"value");
        assert (this.cache(0).get((Object)"key").equals("value"));
        List cacheStores = TestingUtil.cachestores(this.caches());
        for (DummyInMemoryStore dimcs : cacheStores) {
            assert (!dimcs.contains("key"));
            assert (dimcs.stats().get("write") == 0) : "Cache store should NOT contain any entry. Put was with SKIP_SHARED_CACHE_STORE flag.";
        }
    }

    public void testSize() {
        List caches = this.caches();
        Cache cache0 = caches.get(0);
        cache0.put((Object)"key", (Object)"value");
        this.clearStoreStats(TestingUtil.cachestores(this.caches()));
        AssertJUnit.assertEquals((int)1, (int)cache0.size());
        this.assertStoreDistinctInvocationAmount(cache0, 1);
        this.assertStoreStatInvocationEquals(cache0, "size", 1);
    }

    public void testIterationWithSkipCacheLoad(Method method) {
        IntStream.range(0, 10).forEach(i -> this.cache(0).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, i)));
        IntStream.range(5, 10).forEach(i -> this.caches().forEach(c -> c.evict((Object)TestingUtil.k(method, i))));
        for (DummyInMemoryStore store : TestingUtil.cachestores(this.caches())) {
            AssertJUnit.assertEquals((long)10L, (long)store.size());
        }
        this.assertIterationData(method, (Cache<String, String>)this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD), 5);
        this.assertIterationData(method, this.cache(0), 10);
    }

    private void assertIterationData(Method method, Cache<String, String> cache, int expectedSize) {
        AssertJUnit.assertEquals((int)expectedSize, (int)cache.size());
        HashMap entries = new HashMap();
        for (Map.Entry e : cache.entrySet()) {
            entries.put(e.getKey(), e.getValue());
        }
        AssertJUnit.assertEquals((String)("Wrong size: " + String.valueOf(entries)), (int)expectedSize, (int)entries.size());
        IntStream.range(0, expectedSize).forEach(i -> AssertJUnit.assertEquals((String)("Wrong key " + i), (Object)TestingUtil.v(method, i), entries.get(TestingUtil.k(method, i))));
        HashSet keys = new HashSet(cache.keySet());
        AssertJUnit.assertEquals((String)("Wrong size: " + String.valueOf(keys)), (int)expectedSize, (int)keys.size());
        IntStream.range(0, expectedSize).forEach(i -> AssertJUnit.assertTrue((String)("Wrong key " + i), (boolean)keys.contains(TestingUtil.k(method, i))));
        HashSet values = new HashSet(cache.values());
        AssertJUnit.assertEquals((String)("Wrong size: " + String.valueOf(values)), (int)expectedSize, (int)values.size());
        IntStream.range(0, expectedSize).forEach(i -> AssertJUnit.assertTrue((String)("Wrong value " + i), (boolean)values.contains(TestingUtil.v(method, i))));
    }

    private void assertStoreStatInvocationEquals(Cache<String, String> cache, String invocationName, int invocationCount) {
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        AssertJUnit.assertEquals((int)invocationCount, (int)dims.stats().get(invocationName));
    }

    private void assertStoreDistinctInvocationAmount(Cache<String, String> cache, int distinctInvocations) {
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        AssertJUnit.assertEquals((long)distinctInvocations, (long)dims.stats().values().stream().filter(i -> i > 0).count());
    }
}

