/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import jakarta.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.PassivatePersistentTest", groups={"functional"})
public class PassivatePersistentTest
extends AbstractInfinispanTest {
    Cache<String, String> cache;
    DummyInMemoryStore store;
    TransactionManager tm;
    ConfigurationBuilder cfg;
    CacheContainer cm;

    @BeforeMethod
    public void setUp() {
        this.cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)this.cfg.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.getClass().getName()).purgeOnStartup(false);
        this.cm = TestCacheManagerFactory.createCacheManager(this.cfg);
        this.cache = this.cm.getCache();
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        this.store.clear();
        TestingUtil.killCacheManagers(this.cm);
    }

    public void testPersistence() throws PersistenceException {
        this.cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.cache.get((Object)"k")));
        this.cache.evict((Object)"k");
        AssertJUnit.assertTrue((boolean)this.store.contains("k"));
        AssertJUnit.assertEquals((String)"v", (String)((String)this.cache.get((Object)"k")));
        this.cache.put((Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((Object)"v", (Object)this.store.loadEntry("k").getValue());
        this.cache.stop();
        this.cache.start();
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        AssertJUnit.assertEquals((Object)"v2", (Object)this.store.loadEntry("k").getValue());
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.cache.get((Object)"k")));
    }
}

