/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.InitCountTest")
public class InitCountTest
extends AbstractCacheTest {
    public void testInitInvocationCountNoDelegate() {
        this.test(false);
    }

    public void testInitInvocationCountWithDelegate() {
        this.test(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(boolean async) {
        ConfigurationBuilder dcc = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        DummyInMemoryStoreConfigurationBuilder builder = (DummyInMemoryStoreConfigurationBuilder)dcc.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        if (async) {
            builder.async().enable();
        }
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager(dcc);
        Cache cache = cacheManager.getCache();
        try {
            DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
            AssertJUnit.assertEquals((int)1, (int)dims.getInitCount());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }
}

