/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.Arrays;
import java.util.HashSet;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.ThreeWaySplitAndMergeTest")
public class ThreeWaySplitAndMergeTest
extends BasePartitionHandlingTest {
    private static final Log log = LogFactory.getLog(ThreeWaySplitAndMergeTest.class);

    @Override
    public Object[] factory() {
        return new Object[]{new ThreeWaySplitAndMergeTest().partitionHandling(PartitionHandling.DENY_READ_WRITES), new ThreeWaySplitAndMergeTest().partitionHandling(PartitionHandling.ALLOW_READS)};
    }

    public void testSplitAndMerge1() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(0, 1), new BasePartitionHandlingTest.PartitionDescriptor(2), new BasePartitionHandlingTest.PartitionDescriptor(3));
    }

    public void testSplitAndMerge2() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(1, 2), new BasePartitionHandlingTest.PartitionDescriptor(0), new BasePartitionHandlingTest.PartitionDescriptor(3));
    }

    public void testSplitAndMerge3() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(2, 3), new BasePartitionHandlingTest.PartitionDescriptor(0), new BasePartitionHandlingTest.PartitionDescriptor(1));
    }

    public void testSplitAndMerge4() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(2, 3), new BasePartitionHandlingTest.PartitionDescriptor(1), new BasePartitionHandlingTest.PartitionDescriptor(0));
    }

    private void testSplitAndMerge(BasePartitionHandlingTest.PartitionDescriptor p0, BasePartitionHandlingTest.PartitionDescriptor p1, BasePartitionHandlingTest.PartitionDescriptor p2) throws Exception {
        int i;
        MagicKey k0 = new MagicKey("k0", this.cache(p0.node(0)), this.cache(p0.node(1)));
        this.cache(0).put((Object)k0, (Object)0);
        MagicKey k1 = new MagicKey("k1", this.cache(p0.node(1)), this.cache(p1.node(0)));
        this.cache(1).put((Object)k1, (Object)1);
        MagicKey k2 = new MagicKey("k2", this.cache(p1.node(0)), this.cache(p2.node(0)));
        this.cache(2).put((Object)k2, (Object)2);
        MagicKey k3 = new MagicKey(this.cache(p2.node(0)), this.cache(p0.node(0)));
        this.cache(3).put((Object)k3, (Object)3);
        log.trace((Object)"Before split.");
        this.splitCluster(p0.getNodes(), p1.getNodes(), p2.getNodes());
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        this.partition(2).assertDegradedMode();
        this.partition(0).assertKeyAvailableForRead(k0, 0);
        if (this.partitionHandling == PartitionHandling.DENY_READ_WRITES) {
            this.partition(0).assertKeysNotAvailableForRead(k1, k2, k3);
            this.partition(1).assertKeysNotAvailableForRead(k0, k1, k2, k3);
            this.partition(2).assertKeysNotAvailableForRead(k0, k1, k2, k3);
        } else {
            this.partition(0).assertKeyAvailableForRead(k1, 1);
            this.partition(0).assertKeyAvailableForRead(k3, 3);
            this.partition(0).assertKeyNotAvailableForRead(k2);
            this.partition(1).assertKeyAvailableForRead(k1, 1);
            this.partition(1).assertKeyAvailableForRead(k2, 2);
            this.partition(1).assertKeyNotAvailableForRead(k3);
            this.partition(2).assertKeyAvailableForRead(k2, 2);
            this.partition(2).assertKeyAvailableForRead(k3, 3);
            this.partition(2).assertKeyNotAvailableForRead(k1);
        }
        Assert.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k0));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k1));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k2));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k3));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k0));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k1));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k2));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k3));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k0));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k1));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k2));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k3));
        Assert.assertFalse((boolean)this.dataContainer(p2.node(0)).containsKey((Object)k0));
        Assert.assertFalse((boolean)this.dataContainer(p2.node(0)).containsKey((Object)k1));
        Assert.assertTrue((boolean)this.dataContainer(p2.node(0)).containsKey((Object)k2));
        Assert.assertTrue((boolean)this.dataContainer(p2.node(0)).containsKey((Object)k3));
        this.partition(0).assertKeyAvailableForWrite(k0, -1);
        this.partition(1).assertKeysNotAvailableForWrite(k1, k2, k3);
        this.partition(1).assertKeysNotAvailableForWrite(k0, k1, k2, k3);
        this.partition(2).assertKeysNotAvailableForWrite(k0, k1, k2, k3);
        log.tracef("Before the 1st merge P0 = %s, P1 = %s, P2 = %s", (Object)this.partition(0), (Object)this.partition(1), (Object)this.partition(2));
        Assert.assertEquals((int)this.partitions.length, (int)3);
        this.partition(0).merge(this.partition(1));
        Assert.assertEquals((int)this.partitions.length, (int)2);
        log.tracef("After the 1st merge P0 = %s, P1 = %s", (Object)this.partition(0), (Object)this.partition(1));
        this.partition(0).assertAvailabilityMode(AvailabilityMode.AVAILABLE);
        this.partition(1).assertAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
        this.partition(0).assertKeyAvailableForRead(k0, -1);
        this.partition(0).assertKeyAvailableForRead(k1, 1);
        this.partition(0).assertKeyAvailableForRead(k2, 2);
        this.partition(0).assertKeyAvailableForRead(k3, 3);
        this.partition(0).assertKeyAvailableForWrite(k0, 10);
        this.partition(0).assertKeyAvailableForWrite(k1, 11);
        this.partition(0).assertKeyAvailableForWrite(k2, 12);
        this.partition(0).assertKeyAvailableForWrite(k3, 13);
        HashSet<Address> members = new HashSet<Address>(Arrays.asList(this.address(p0.node(0)), this.address(p0.node(1)), this.address(p1.node(0))));
        Assert.assertEquals(new HashSet(this.advancedCache(p0.node(0)).getDistributionManager().getWriteConsistentHash().getMembers()), members);
        Assert.assertEquals(new HashSet(this.advancedCache(p0.node(1)).getDistributionManager().getWriteConsistentHash().getMembers()), members);
        Assert.assertEquals(new HashSet(this.advancedCache(p1.node(0)).getDistributionManager().getWriteConsistentHash().getMembers()), members);
        if (this.partitionHandling == PartitionHandling.DENY_READ_WRITES) {
            this.partition(1).assertKeysNotAvailableForRead(k0, k1, k2, k3);
        }
        members = new HashSet<Address>(Arrays.asList(this.address(0), this.address(1), this.address(2), this.address(3)));
        Assert.assertEquals(new HashSet(this.advancedCache(p2.node(0)).getDistributionManager().getWriteConsistentHash().getMembers()), members);
        for (i = 0; i < 100; ++i) {
            this.dataContainer(p2.node(0)).put((Object)i, (Object)i, null);
        }
        log.tracef("Before the 2nd merge P0 = %s, P1 = %s", (Object)this.partition(0), (Object)this.partition(1));
        this.partition(0).merge(this.partition(1));
        log.tracef("After 2nd merge P0=%s", (Object)this.partition(0));
        Assert.assertEquals((int)this.partitions.length, (int)1);
        this.partition(0).assertAvailabilityMode(AvailabilityMode.AVAILABLE);
        this.partition(0).assertKeyAvailableForRead(k0, 10);
        this.partition(0).assertKeyAvailableForRead(k1, 11);
        this.partition(0).assertKeyAvailableForRead(k2, 12);
        this.partition(0).assertKeyAvailableForRead(k3, 13);
        for (i = 0; i < 100; ++i) {
            this.partition(0).assertKeyAvailableForRead(i, null);
        }
        this.cache(0).put((Object)k0, (Object)10);
        this.cache(1).put((Object)k1, (Object)100);
        this.cache(2).put((Object)k2, (Object)1000);
        this.cache(3).put((Object)k3, (Object)10000);
        this.assertExpectedValue(10, k0);
        this.assertExpectedValue(100, k1);
        this.assertExpectedValue(1000, k2);
        this.assertExpectedValue(10000, k3);
    }
}

