/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.ArrayList;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.PartitionHappeningTest")
@InCacheMode(value={CacheMode.DIST_SYNC})
public class PartitionHappeningTest
extends BasePartitionHandlingTest {
    public PartitionHappeningTest() {
        this.partitionHandling = PartitionHandling.ALLOW_READ_WRITES;
    }

    public void testPartitionHappening() throws Throwable {
        ArrayList<BasePartitionHandlingTest.ViewChangedHandler> listeners = new ArrayList<BasePartitionHandlingTest.ViewChangedHandler>();
        for (int i = 0; i < this.caches().size(); ++i) {
            BasePartitionHandlingTest.ViewChangedHandler listener = new BasePartitionHandlingTest.ViewChangedHandler();
            this.cache(i).getCacheManager().addListener((Object)listener);
            listeners.add(listener);
        }
        this.splitCluster({0, 1}, {2, 3});
        PartitionHappeningTest.eventually(() -> {
            for (BasePartitionHandlingTest.ViewChangedHandler l : listeners) {
                if (l.isNotified()) continue;
                return false;
            }
            return true;
        });
        this.eventuallyEquals(2, () -> this.advancedCache(0).getRpcManager().getTransport().getMembers().size());
        PartitionHappeningTest.eventually(() -> this.clusterAndChFormed(0, 2));
        PartitionHappeningTest.eventually(() -> this.clusterAndChFormed(1, 2));
        PartitionHappeningTest.eventually(() -> this.clusterAndChFormed(2, 2));
        PartitionHappeningTest.eventually(() -> this.clusterAndChFormed(3, 2));
        this.cache(0).put((Object)"k", (Object)"v1");
        this.cache(2).put((Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((Object)this.cache(0).get((Object)"k"), (Object)"v1");
        AssertJUnit.assertEquals((Object)this.cache(1).get((Object)"k"), (Object)"v1");
        AssertJUnit.assertEquals((Object)this.cache(2).get((Object)"k"), (Object)"v2");
        AssertJUnit.assertEquals((Object)this.cache(3).get((Object)"k"), (Object)"v2");
        this.partition(0).merge(this.partition(1));
        AssertJUnit.assertTrue((boolean)this.clusterAndChFormed(0, 4));
        AssertJUnit.assertTrue((boolean)this.clusterAndChFormed(1, 4));
        AssertJUnit.assertTrue((boolean)this.clusterAndChFormed(2, 4));
        AssertJUnit.assertTrue((boolean)this.clusterAndChFormed(3, 4));
    }

    public boolean clusterAndChFormed(int cacheIndex, int memberCount) {
        return this.advancedCache(cacheIndex).getRpcManager().getTransport().getMembers().size() == memberCount && this.advancedCache(cacheIndex).getDistributionManager().getWriteConsistentHash().getMembers().size() == memberCount;
    }
}

