/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.partitionhandling.BaseOptimisticTxPartitionAndMergeTest;
import org.infinispan.partitionhandling.BaseTxPartitionAndMergeTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.OptimisticTxPartitionAndMergeDuringPrepareTest")
public class OptimisticTxPartitionAndMergeDuringPrepareTest
extends BaseOptimisticTxPartitionAndMergeTest {
    private static final Log log = LogFactory.getLog(OptimisticTxPartitionAndMergeDuringPrepareTest.class);

    public void testDegradedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, true, true);
    }

    public void testDegradedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, true, false);
    }

    public void testOriginatorIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, true, true);
    }

    public void testOriginatorIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, true, false);
    }

    public void testPrimaryOwnerIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, false, true);
    }

    public void testPrimaryOwnerIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, false, false);
    }

    @Override
    protected void checkLocksDuringPartition(BaseTxPartitionAndMergeTest.SplitMode splitMode, BaseTxPartitionAndMergeTest.KeyInfo keyInfo, boolean discard) {
        switch (splitMode) {
            case ORIGINATOR_ISOLATED: {
                this.assertEventuallyNotLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
                break;
            }
            case PRIMARY_OWNER_ISOLATED: {
                this.assertEventuallyNotLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
                break;
            }
            case BOTH_DEGRADED: {
                this.assertEventuallyNotLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
            }
        }
        this.assertEventuallyNotLocked(this.cache(2, "opt-cache"), keyInfo.getKey2());
    }

    @Override
    protected boolean forceRollback() {
        return false;
    }

    @Override
    protected Class<? extends TransactionBoundaryCommand> getCommandClass() {
        return PrepareCommand.class;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

