/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.Collection;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerTest;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerUtilTest;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractClusterListenerTxTest
extends AbstractClusterListenerTest {
    protected AbstractClusterListenerTxTest(CacheMode cacheMode) {
        super(true, cacheMode);
    }

    protected void verifyCreation(Collection<CacheEntryEvent> events, Object key, Object expectedValue) {
        boolean found = false;
        for (CacheEntryEvent event : events) {
            if (Event.Type.CACHE_ENTRY_CREATED != event.getType() || !key.equals(event.getKey()) || !expectedValue.equals(event.getValue())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found, (String)("No entry was created in provided events " + String.valueOf(events) + " matching key " + String.valueOf(key) + " and value " + String.valueOf(expectedValue)));
    }

    @Test
    public void testBatchedCommitOriginatorNotLocal() throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        MagicKey key1 = new MagicKey(cache1, cache2);
        MagicKey key2 = new MagicKey(cache2, cache1);
        TransactionManager tm = cache2.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache2.put((Object)key1, (Object)"first-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        cache2.put((Object)key2, (Object)"second-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        tm.commit();
        Assert.assertEquals((int)clusterListener.events.size(), (int)2);
        this.verifyCreation(clusterListener.events, key1, "first-value");
        this.verifyCreation(clusterListener.events, key2, "second-value");
    }

    @Test
    public void testBatchedCommitKeyNotLocalLocal() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException, NotSupportedException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        MagicKey key1 = new MagicKey(cache1, cache2);
        MagicKey key2 = new MagicKey(cache2, cache1);
        TransactionManager tm = cache2.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache0.put((Object)key1, (Object)"first-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        cache0.put((Object)key2, (Object)"second-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        tm.commit();
        Assert.assertEquals((int)clusterListener.events.size(), (int)2);
        this.verifyCreation(clusterListener.events, key1, "first-value");
        this.verifyCreation(clusterListener.events, key2, "second-value");
    }

    @Test
    public void testBatchedCommitLocal() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException, NotSupportedException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        MagicKey key1 = new MagicKey(cache0);
        MagicKey key2 = new MagicKey(cache1, cache0);
        TransactionManager tm = cache2.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache0.put((Object)key1, (Object)"first-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        cache0.put((Object)key2, (Object)"second-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        tm.commit();
        Assert.assertEquals((int)clusterListener.events.size(), (int)2);
        this.verifyCreation(clusterListener.events, key1, "first-value");
        this.verifyCreation(clusterListener.events, key2, "second-value");
    }

    @Test
    public void testRolledBackNotLocal() throws SystemException, NotSupportedException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        MagicKey key1 = new MagicKey(cache1, cache2);
        MagicKey key2 = new MagicKey(cache2, cache1);
        TransactionManager tm = cache2.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache2.put((Object)key1, (Object)"first-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        cache2.put((Object)key2, (Object)"second-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        tm.rollback();
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
    }

    @Test
    public void testRolledBackOriginatorNotLocal() throws SystemException, NotSupportedException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        MagicKey key1 = new MagicKey(cache0);
        MagicKey key2 = new MagicKey(cache1, cache0);
        TransactionManager tm = cache2.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache2.put((Object)key1, (Object)"first-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        cache2.put((Object)key2, (Object)"second-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        tm.rollback();
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
    }

    @Test
    public void testRolledBackLocal() throws SystemException, NotSupportedException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        MagicKey key1 = new MagicKey(cache0);
        MagicKey key2 = new MagicKey(cache1, cache0);
        TransactionManager tm = cache2.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache0.put((Object)key1, (Object)"first-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        cache0.put((Object)key2, (Object)"second-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        tm.rollback();
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
    }

    @Test
    public void testMultipleKeysSameOwnerBatchNotified() throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = new AbstractClusterListenerUtilTest.ClusterListener();
        cache0.addListener((Object)clusterListener);
        MagicKey key1 = new MagicKey(cache1);
        MagicKey key2 = new MagicKey(cache1);
        TransactionManager tm = cache2.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache2.put((Object)key1, (Object)"first-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        cache2.put((Object)key2, (Object)"second-value");
        Assert.assertEquals((int)clusterListener.events.size(), (int)0);
        tm.commit();
        Assert.assertEquals((int)clusterListener.events.size(), (int)2);
        this.verifyCreation(clusterListener.events, key1, "first-value");
        this.verifyCreation(clusterListener.events, key2, "second-value");
    }
}

