/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierTest")
public class CacheNotifierTest
extends AbstractInfinispanTest {
    protected Cache<Object, Object> cache;
    protected EmbeddedCacheManager cm;

    @BeforeMethod
    public void setUp() throws Exception {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).clustering().cacheMode(CacheMode.LOCAL).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cm = TestCacheManagerFactory.createCacheManager(c);
        this.cache = this.getCache();
        CacheNotifier mockNotifier = (CacheNotifier)Mockito.mock(CacheNotifier.class, i -> CompletableFutures.completedNull());
        ((CacheNotifier)Mockito.doReturn((Object)true).when((Object)mockNotifier)).hasListener((Class)ArgumentMatchers.any());
        TestingUtil.replaceComponent(this.cache, CacheNotifier.class, mockNotifier, true);
    }

    protected Cache<Object, Object> getCache() {
        return this.cm.getCache();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
        this.cm.stop();
    }

    @AfterClass
    public void destroyManager() {
        TestingUtil.killCacheManagers(this.cache.getCacheManager());
    }

    private CacheNotifier getMockNotifier(Cache cache) {
        return (CacheNotifier)ComponentRegistry.componentOf((Cache)cache, CacheNotifier.class);
    }

    protected Matcher<FlagAffectedCommand> getFlagMatcher() {
        CustomTypeSafeMatcher<FlagAffectedCommand> flagAffectedCommandMatcher = new CustomTypeSafeMatcher<FlagAffectedCommand>("SKIP_LISTENER_NOTIFICATION"){

            protected boolean matchesSafely(FlagAffectedCommand item) {
                return !item.hasAnyFlag(FlagBitSets.SKIP_LISTENER_NOTIFICATION);
            }
        };
        return flagAffectedCommandMatcher;
    }

    public void testVisit() throws Exception {
        Matcher<FlagAffectedCommand> matcher = this.getFlagMatcher();
        this.initCacheData(this.cache, Collections.singletonMap("key", "value"));
        this.cache.get((Object)"key");
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryVisited(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value"), ArgumentMatchers.eq((boolean)true), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryVisited(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value"), ArgumentMatchers.eq((boolean)false), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
    }

    public void testRemoveData() throws Exception {
        Matcher<FlagAffectedCommand> matcher = this.getFlagMatcher();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.initCacheData(this.cache, data);
        this.cache.remove((Object)"key2");
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryRemoved(ArgumentMatchers.eq((Object)"key2"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)true), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryRemoved(ArgumentMatchers.eq((Object)"key2"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)false), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
    }

    public void testPutMap() throws Exception {
        Matcher<FlagAffectedCommand> matcher = this.getFlagMatcher();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.cache.putAll(data);
        this.expectSingleEntryCreated(this.cache, "key", "value", matcher);
        this.expectSingleEntryCreated(this.cache, "key2", "value2", matcher);
    }

    public void testOnlyModification() throws Exception {
        Matcher<FlagAffectedCommand> matcher = this.getFlagMatcher();
        this.initCacheData(this.cache, Collections.singletonMap("key", "value"));
        this.cache.put((Object)"key", (Object)"value2");
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)true), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)false), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        this.cache.put((Object)"key", (Object)"value2");
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)true), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)false), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
    }

    public void testReplaceNotification() throws Exception {
        Matcher<FlagAffectedCommand> matcher = this.getFlagMatcher();
        this.initCacheData(this.cache, Collections.singletonMap("key", "value"));
        this.cache.replace((Object)"key", (Object)"value", (Object)"value2");
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)true), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache))).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value2"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)false), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
    }

    public void testReplaceNoNotificationOnNoChange() throws Exception {
        this.initCacheData(this.cache, Collections.singletonMap("key", "value"));
        this.cache.replace((Object)"key", (Object)"value2", (Object)"value3");
        Matcher<FlagAffectedCommand> matcher = this.getFlagMatcher();
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache), (VerificationMode)Mockito.never())).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value3"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value3"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)true), (InvocationContext)ArgumentMatchers.any(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(this.cache), (VerificationMode)Mockito.never())).notifyCacheEntryModified(ArgumentMatchers.eq((Object)"key"), ArgumentMatchers.eq((Object)"value3"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((Object)"value3"), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)false), (InvocationContext)ArgumentMatchers.any(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
    }

    public void testNonexistentVisit() throws Exception {
        this.cache.get((Object)"doesNotExist");
    }

    public void testNonexistentRemove() throws Exception {
        this.cache.remove((Object)"doesNotExist");
    }

    public void testCreation() throws Exception {
        this.creation(this.cache, this.getFlagMatcher());
    }

    private void creation(Cache<Object, Object> cache, Matcher<FlagAffectedCommand> matcher) {
        cache.put((Object)"key", (Object)"value");
        this.expectSingleEntryCreated(cache, "key", "value", matcher);
    }

    private void initCacheData(Cache cache, Map<String, String> data) {
        cache.putAll(data);
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(cache), (VerificationMode)Mockito.atLeastOnce())).notifyCacheEntryCreated(ArgumentMatchers.any(), ArgumentMatchers.any(), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.anyBoolean(), (InvocationContext)ArgumentMatchers.isA(InvocationContext.class), (FlagAffectedCommand)this.getExpectedPutMapCommand());
    }

    protected PutMapCommand getExpectedPutMapCommand() {
        return (PutMapCommand)ArgumentMatchers.isA(PutMapCommand.class);
    }

    private void expectSingleEntryCreated(Cache cache, Object key, Object value, Matcher<FlagAffectedCommand> matcher) {
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(cache))).notifyCacheEntryCreated(ArgumentMatchers.eq((Object)key), ArgumentMatchers.eq((Object)value), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)true), (InvocationContext)ArgumentMatchers.any(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
        ((CacheNotifier)Mockito.verify((Object)this.getMockNotifier(cache))).notifyCacheEntryCreated(ArgumentMatchers.eq((Object)key), ArgumentMatchers.eq((Object)value), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.eq((boolean)false), (InvocationContext)ArgumentMatchers.any(InvocationContext.class), (FlagAffectedCommand)MockitoHamcrest.argThat(matcher));
    }
}

