/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierFilterTest")
public class CacheNotifierFilterTest
extends MultipleCacheManagersTest {
    protected final String CACHE_NAME = "testCache";
    protected ConfigurationBuilder builderUsed;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.createClusteredCaches(3, "testCache", this.builderUsed);
    }

    @Test
    public void testCacheEntryVisitedEventFiltered() {
        String key = "key";
        String value = "value";
        Cache cache0 = this.cache(0, "testCache");
        cache0.put((Object)key, (Object)value);
        TestListener listener = new TestListener();
        CacheEventFilter filter = (k, oldValue, oldMetadata, newValue, newMetadata, eventType) -> !Objects.equals(k, key);
        cache0.addFilteredListener((Object)listener, filter, null, Util.asSet((Object[])new Class[]{CacheEntryVisited.class}));
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)key)));
        AssertJUnit.assertEquals((int)0, (int)listener.visitedEvents.size());
        String notKey = "not" + key;
        cache0.put((Object)notKey, (Object)value);
        cache0.get((Object)("not" + key));
        cache0.getAdvancedCache().getAll(Collections.singleton("not" + key));
        AssertJUnit.assertEquals((int)4, (int)listener.visitedEvents.size());
    }

    @Test
    public void testNonCacheEventsNotFiltered() {
        Cache cache0 = this.cache(0, "testCache");
        TestListener listener = new TestListener();
        cache0.addListener((Object)listener, (key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> false, null);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.createCache("testCache", this.builderUsed.build());
        this.waitForClusterToForm("testCache");
        AssertJUnit.assertEquals((int)8, (int)listener.topologyEvents.size());
    }

    @Test
    public void testVisitationsBlocked() {
        String key = "key";
        String value = "value";
        Cache cache0 = this.cache(0, "testCache");
        cache0.put((Object)key, (Object)value);
        AllCacheEntryListener listener = new AllCacheEntryListener();
        cache0.addListener((Object)listener, (CacheEventFilter)new VisitedFilter(), null);
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)key)));
        AssertJUnit.assertEquals((int)0, (int)listener.events.size());
        String notKey = "not" + key;
        cache0.put((Object)notKey, (Object)value);
        cache0.get((Object)("not" + key));
        AssertJUnit.assertEquals((int)2, (int)listener.events.size());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_CREATED, (Object)listener.events.get(0).getType());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_CREATED, (Object)listener.events.get(1).getType());
    }

    @Listener
    private static class TestListener {
        private static final Log log = LogFactory.getLog(TestListener.class);
        private final List<CacheEntryVisitedEvent> visitedEvents = Collections.synchronizedList(new ArrayList());
        private final List<TopologyChangedEvent> topologyEvents = Collections.synchronizedList(new ArrayList());

        private TestListener() {
        }

        @CacheEntryVisited
        public void entryVisited(CacheEntryVisitedEvent event) {
            log.tracef("Visited %s", event.getKey());
            this.visitedEvents.add(event);
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent event) {
            this.topologyEvents.add(event);
        }
    }

    @Listener
    private static class AllCacheEntryListener {
        private final List<CacheEntryEvent> events = Collections.synchronizedList(new ArrayList());

        private AllCacheEntryListener() {
        }

        @CacheEntryVisited
        @CacheEntryActivated
        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryCreated
        @CacheEntryInvalidated
        @CacheEntryPassivated
        public void listenEvent(CacheEntryEvent event) {
            this.events.add(event);
        }
    }

    private static class VisitedFilter
    implements CacheEventFilter<String, String> {
        private VisitedFilter() {
        }

        public boolean accept(String key, String oldValue, Metadata oldMetadata, String newValue, Metadata newMetadata, EventType eventType) {
            return eventType.getType() != Event.Type.CACHE_ENTRY_VISITED;
        }
    }
}

