/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.ObjectDuplicator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.CountMarshallingPojo;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.core.StoreAsBinaryTest")
public class StoreAsBinaryTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(StoreAsBinaryTest.class);
    private static final String POJO_NAME = StoreAsBinaryTest.class.getName();

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder replSync = StoreAsBinaryTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        replSync.memory().storageType(StorageType.BINARY);
        this.createClusteredCaches(2, "replSync", TestDataSCI.INSTANCE, replSync);
    }

    @Override
    @AfterClass
    protected void destroy() {
        super.destroy();
    }

    @BeforeMethod
    public void resetSerializationCounts() {
        CountMarshallingPojo.reset(POJO_NAME);
    }

    public void testNonMarshallable() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        Exceptions.expectException(MarshallingException.class, () -> cache1.put((Object)"Hello", new Object()));
        Exceptions.expectException(MarshallingException.class, () -> cache1.put(new Object(), (Object)"Hello"));
    }

    public void testReleaseObjectValueReferences() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        CountMarshallingPojo value = new CountMarshallingPojo(POJO_NAME, 1);
        cache1.put((Object)"key", (Object)value);
        AssertJUnit.assertTrue((boolean)cache1.containsKey((Object)"key"));
        DataContainer dc1 = (DataContainer)TestingUtil.extractComponent(cache1, InternalDataContainer.class);
        InternalCacheEntry ice = dc1.peek(this.boxKey(cache1, "key"));
        Object o = ice.getValue();
        AssertJUnit.assertTrue((boolean)(o instanceof WrappedByteArray));
        AssertJUnit.assertEquals((Object)value, (Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((Object)value, (Object)this.unboxValue(cache1, o));
        DataContainer dc2 = (DataContainer)TestingUtil.extractComponent(cache2, InternalDataContainer.class);
        ice = dc2.peek(this.boxKey(cache2, "key"));
        o = ice.getValue();
        AssertJUnit.assertTrue((boolean)(o instanceof WrappedByteArray));
        AssertJUnit.assertEquals((Object)value, (Object)cache2.get((Object)"key"));
        AssertJUnit.assertEquals((Object)value, (Object)this.unboxValue(cache2, o));
    }

    private Object boxKey(Cache<?, ?> cache, Object key) {
        EncoderCache c = (EncoderCache)cache;
        return c.keyToStorage(key);
    }

    private Object unboxKey(Cache<?, ?> cache, Object key) {
        EncoderCache c = (EncoderCache)cache;
        return c.keyFromStorage(key);
    }

    private Object unboxValue(Cache<?, ?> cache, Object value) {
        EncoderCache c = (EncoderCache)cache;
        return c.valueFromStorage(value);
    }

    public void testReleaseObjectKeyReferences() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        CountMarshallingPojo key = new CountMarshallingPojo(POJO_NAME, 1);
        cache1.put((Object)key, (Object)"value");
        DataContainer dc1 = (DataContainer)TestingUtil.extractComponent(cache1, InternalDataContainer.class);
        Object firstKeyStorage = ((InternalCacheEntry)dc1.iterator().next()).getKey();
        Object firstKey = cache1.getAdvancedCache().getKeyDataConversion().fromStorage(firstKeyStorage);
        AssertJUnit.assertEquals((Object)key, (Object)firstKey);
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)key)));
        DataContainer dc2 = (DataContainer)TestingUtil.extractComponent(cache2, InternalDataContainer.class);
        firstKeyStorage = ((InternalCacheEntry)dc2.iterator().next()).getKey();
        firstKey = cache1.getAdvancedCache().getKeyDataConversion().fromStorage(firstKeyStorage);
        AssertJUnit.assertEquals((Object)key, (Object)firstKey);
        AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get((Object)key)));
    }

    public void testKeySetValuesEntrySetCollectionReferences() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        CountMarshallingPojo key1 = new CountMarshallingPojo(POJO_NAME, 1);
        CountMarshallingPojo value1 = new CountMarshallingPojo(POJO_NAME, 11);
        CountMarshallingPojo key2 = new CountMarshallingPojo(POJO_NAME, 2);
        CountMarshallingPojo value2 = new CountMarshallingPojo(POJO_NAME, 22);
        String key3 = "3";
        String value3 = "three";
        cache1.put((Object)key1, (Object)value1);
        cache1.put((Object)key2, (Object)value2);
        cache1.put((Object)key3, (Object)value3);
        HashSet<Object> expKeys = new HashSet<Object>();
        expKeys.add(key1);
        expKeys.add(key2);
        expKeys.add(key3);
        HashSet<Object> expValues = new HashSet<Object>();
        expValues.add(value1);
        expValues.add(value2);
        expValues.add(value3);
        Set expKeyEntries = ObjectDuplicator.duplicateSet(expKeys);
        Set expValueEntries = ObjectDuplicator.duplicateSet(expValues);
        CacheSet keys = cache2.keySet();
        for (Object key : keys) {
            AssertJUnit.assertTrue((boolean)expKeys.remove(key));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expKeys) + " in iterator!"), (boolean)expKeys.isEmpty());
        CacheCollection values = cache2.values();
        for (Object key : values) {
            AssertJUnit.assertTrue((boolean)expValues.remove(key));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expValues) + " in iterator!"), (boolean)expValues.isEmpty());
        CacheSet entries = cache2.entrySet();
        for (Map.Entry entry : entries) {
            AssertJUnit.assertTrue((boolean)expKeyEntries.remove(entry.getKey()));
            AssertJUnit.assertTrue((boolean)expValueEntries.remove(entry.getValue()));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expKeyEntries) + " in iterator!"), (boolean)expKeyEntries.isEmpty());
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expValueEntries) + " in iterator!"), (boolean)expValueEntries.isEmpty());
    }

    public void testUnsupportedKeyValueCollectionOperations() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        CacheSet keys = this.cache(0, "replSync").keySet();
        CacheCollection values = this.cache(0, "replSync").values();
        Collection[] collections = new Collection[]{keys, values};
        String newObj = "foo";
        ArrayList<String> newObjCol = new ArrayList<String>();
        newObjCol.add(newObj);
        for (Collection col : collections) {
            Exceptions.expectException(UnsupportedOperationException.class, () -> col.add(newObj));
            Exceptions.expectException(UnsupportedOperationException.class, () -> col.addAll(newObjCol));
        }
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAddMethodsForEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        CacheSet entries = this.cache(0, "replSync").entrySet();
        entries.add(TestingUtil.createMapEntry("4", "four"));
    }

    public void testRemoveMethodOfKeyValueEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        CacheSet keys = this.cache(0, "replSync").keySet();
        keys.remove("1");
        AssertJUnit.assertEquals((int)2, (int)this.cache(0, "replSync").size());
        CacheCollection values = this.cache(0, "replSync").values();
        values.remove("two");
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, "replSync").size());
        CacheSet entries = this.cache(0, "replSync").entrySet();
        entries.remove(TestingUtil.createMapEntry("3", "three"));
        AssertJUnit.assertEquals((int)0, (int)this.cache(0, "replSync").size());
    }

    public void testClearMethodOfKeyCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        CacheSet keys = this.cache(0, "replSync").keySet();
        keys.clear();
        AssertJUnit.assertEquals((int)0, (int)this.cache(0, "replSync").size());
    }

    public void testClearMethodOfValuesCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        CacheCollection values = this.cache(0, "replSync").values();
        values.clear();
        AssertJUnit.assertEquals((int)0, (int)this.cache(0, "replSync").size());
    }

    public void testClearMethodOfEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        CacheSet entries = this.cache(0, "replSync").entrySet();
        entries.clear();
        AssertJUnit.assertEquals((int)0, (int)this.cache(0, "replSync").size());
    }

    public void testRemoveAllMethodOfKeyCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        ArrayList<String> keyCollection = new ArrayList<String>(2);
        keyCollection.add("2");
        keyCollection.add("3");
        CacheSet keys = this.cache(0, "replSync").keySet();
        keys.removeAll(keyCollection);
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, "replSync").size());
    }

    public void testRemoveAllMethodOfValuesCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        ArrayList<String> valueCollection = new ArrayList<String>(2);
        valueCollection.add("one");
        valueCollection.add("two");
        CacheCollection values = this.cache(0, "replSync").values();
        values.removeAll(valueCollection);
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, "replSync").size());
    }

    public void testRemoveAllMethodOfEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        ArrayList<Map.Entry<String, String>> entryCollection = new ArrayList<Map.Entry<String, String>>(2);
        entryCollection.add(TestingUtil.createMapEntry("1", "one"));
        entryCollection.add(TestingUtil.createMapEntry("3", "three"));
        CacheSet entries = this.cache(0, "replSync").entrySet();
        entries.removeAll(entryCollection);
        AssertJUnit.assertEquals((int)1, (int)this.cache(0, "replSync").size());
    }

    public void testRetainAllMethodOfKeyCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        ArrayList<String> keyCollection = new ArrayList<String>(2);
        keyCollection.add("2");
        keyCollection.add("3");
        keyCollection.add("6");
        CacheSet keys = this.cache(0, "replSync").keySet();
        keys.retainAll(keyCollection);
        AssertJUnit.assertEquals((int)2, (int)this.cache(0, "replSync").size());
    }

    public void testRetainAllMethodOfValuesCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        ArrayList<String> valueCollection = new ArrayList<String>(2);
        valueCollection.add("one");
        valueCollection.add("two");
        valueCollection.add("5");
        CacheCollection values = this.cache(0, "replSync").values();
        values.retainAll(valueCollection);
        AssertJUnit.assertEquals((int)2, (int)this.cache(0, "replSync").size());
    }

    public void testRetainAllMethodOfEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        ArrayList<Map.Entry<String, String>> entryCollection = new ArrayList<Map.Entry<String, String>>(3);
        entryCollection.add(TestingUtil.createMapEntry("1", "one"));
        entryCollection.add(TestingUtil.createMapEntry("3", "three"));
        entryCollection.add(TestingUtil.createMapEntry("4", "5"));
        CacheSet entries = this.cache(0, "replSync").entrySet();
        entries.retainAll(entryCollection);
        AssertJUnit.assertEquals((int)2, (int)this.cache(0, "replSync").size());
    }

    public void testEntrySetValueFromEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache(0, "replSync").putAll(m);
        CacheSet entries = this.cache(0, "replSync").entrySet();
        String newString = "new-value";
        for (Map.Entry entry : entries) {
            entry.setValue(newString);
        }
        AssertJUnit.assertEquals((int)3, (int)this.cache(0, "replSync").size());
        AssertJUnit.assertEquals((Object)newString, (Object)this.cache(0, "replSync").get((Object)"1"));
        AssertJUnit.assertEquals((Object)newString, (Object)this.cache(0, "replSync").get((Object)"2"));
        AssertJUnit.assertEquals((Object)newString, (Object)this.cache(0, "replSync").get((Object)"3"));
    }

    public void testKeyValueEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(key1, value1);
        m.put(key2, value2);
        m.put(key3, value3);
        this.cache(0, "replSync").putAll(m);
        assert (3 == this.cache(0, "replSync").size() && 3 == this.cache(0, "replSync").keySet().size() && 3 == this.cache(0, "replSync").values().size() && 3 == this.cache(0, "replSync").entrySet().size());
        HashSet<String> expKeys = new HashSet<String>();
        expKeys.add(key1);
        expKeys.add(key2);
        expKeys.add(key3);
        HashSet<String> expValues = new HashSet<String>();
        expValues.add(value1);
        expValues.add(value2);
        expValues.add(value3);
        Set expKeyEntries = ObjectDuplicator.duplicateSet(expKeys);
        Set expValueEntries = ObjectDuplicator.duplicateSet(expValues);
        CacheSet keys = this.cache(0, "replSync").keySet();
        for (Object key : keys) {
            AssertJUnit.assertTrue((boolean)expKeys.remove(key));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expKeys) + " in iterator!"), (boolean)expKeys.isEmpty());
        CacheCollection values = this.cache(0, "replSync").values();
        for (Object value : values) {
            AssertJUnit.assertTrue((boolean)expValues.remove(value));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expValues) + " in iterator!"), (boolean)expValues.isEmpty());
        CacheSet entries = this.cache(0, "replSync").entrySet();
        for (Map.Entry entry : entries) {
            AssertJUnit.assertTrue((boolean)expKeyEntries.remove(entry.getKey()));
            AssertJUnit.assertTrue((boolean)expValueEntries.remove(entry.getValue()));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expKeyEntries) + " in iterator!"), (boolean)expKeyEntries.isEmpty());
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expValueEntries) + " in iterator!"), (boolean)expValueEntries.isEmpty());
    }

    public void testEqualsAndHashCode() throws Exception {
        GlobalMarshaller marshaller = TestingUtil.extractGlobalMarshaller(this.manager(0));
        CountMarshallingPojo pojo = new CountMarshallingPojo(POJO_NAME, 1);
        WrappedByteArray wb = new WrappedByteArray(marshaller.objectToByteBuffer((Object)pojo));
        WrappedByteArray wb2 = new WrappedByteArray(marshaller.objectToByteBuffer((Object)pojo));
        AssertJUnit.assertEquals((int)wb2.hashCode(), (int)wb.hashCode());
        AssertJUnit.assertEquals((Object)wb, (Object)wb2);
    }

    public void testComputeIfAbsentMethods() {
        Cache cache = this.cache(0, "replSync");
        cache.computeIfAbsent((Object)"1", (SerializableFunction & Serializable)k -> String.valueOf(k) + "1", -1L, TimeUnit.NANOSECONDS);
        AssertJUnit.assertEquals((int)1, (int)cache.size());
        cache.computeIfAbsent((Object)"2", (SerializableFunction & Serializable)k -> String.valueOf(k) + "2", -1L, TimeUnit.NANOSECONDS, -1L, TimeUnit.NANOSECONDS);
        AssertJUnit.assertEquals((int)2, (int)cache.size());
    }

    public void testStores() {
        ConfigurationBuilder cacheCofig = StoreAsBinaryTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        cacheCofig.memory().storageType(StorageType.BINARY);
        DummyInMemoryStoreConfigurationBuilder dimcs = new DummyInMemoryStoreConfigurationBuilder(cacheCofig.persistence());
        dimcs.storeName(this.getClass().getSimpleName());
        cacheCofig.persistence().addStore((StoreConfigurationBuilder)dimcs);
        this.defineConfigurationOnAllManagers("replSync2", cacheCofig);
        this.waitForClusterToForm("replSync2");
        Cache cache1 = this.cache(0, "replSync2");
        Cache cache2 = this.cache(1, "replSync2");
        CountMarshallingPojo pojo = new CountMarshallingPojo(POJO_NAME, 1);
        cache1.put((Object)"key", (Object)pojo);
        AssertJUnit.assertEquals((Object)pojo, (Object)cache2.get((Object)"key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallbackValues() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        MockListener l = new MockListener();
        cache1.addListener((Object)l);
        try {
            CountMarshallingPojo pojo = new CountMarshallingPojo(POJO_NAME, 1);
            cache1.put((Object)"key", (Object)pojo);
            AssertJUnit.assertTrue((String)("received " + l.newValue.getClass().getName()), (boolean)(l.newValue instanceof CountMarshallingPojo));
        }
        finally {
            cache1.removeListener((Object)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoteCallbackValues() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        MockListener l = new MockListener();
        cache2.addListener((Object)l);
        try {
            CountMarshallingPojo pojo = new CountMarshallingPojo(POJO_NAME, 1);
            cache1.put((Object)"key", (Object)pojo);
            AssertJUnit.assertTrue((boolean)(l.newValue instanceof CountMarshallingPojo));
        }
        finally {
            cache2.removeListener((Object)l);
        }
    }

    public void testEvictWithMarshalledValueKey() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        CountMarshallingPojo pojo = new CountMarshallingPojo(POJO_NAME, 1);
        cache1.put((Object)pojo, (Object)pojo);
        cache1.evict((Object)pojo);
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)pojo));
    }

    public void testModificationsOnSameCustomKey() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        CountMarshallingPojo key1 = new CountMarshallingPojo(POJO_NAME, 1);
        log.trace((Object)"First put");
        cache1.put((Object)key1, (Object)"1");
        log.trace((Object)"Second put");
        CountMarshallingPojo key2 = new CountMarshallingPojo(POJO_NAME, 1);
        AssertJUnit.assertEquals((Object)"1", (Object)cache2.put((Object)key2, (Object)"2"));
    }

    public void testReturnValueDeserialization() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        CountMarshallingPojo v1 = new CountMarshallingPojo(POJO_NAME, 1);
        cache1.put((Object)"1", (Object)v1);
        CountMarshallingPojo previous = (CountMarshallingPojo)cache1.put((Object)"1", (Object)new CountMarshallingPojo(POJO_NAME, 2));
        AssertJUnit.assertEquals((Object)v1, (Object)previous);
    }

    public void testGetCacheEntryWithFlag() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        CountMarshallingPojo key1 = new CountMarshallingPojo(POJO_NAME, 1);
        cache1.put((Object)key1, (Object)"1");
        AssertJUnit.assertEquals((String)"1", (String)((String)cache1.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).getCacheEntry((Object)key1).getValue()));
    }

    @Listener
    public static class MockListener {
        Object newValue;

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<Object, Object> e) {
            if (!e.isPre()) {
                this.newValue = e.getValue();
            }
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<Object, Object> e) {
            if (!e.isPre()) {
                this.newValue = e.getValue();
            }
        }
    }
}

