/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.encoding.DataConversion;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.MarshalledValuesFineGrainedTest")
public class MarshalledValuesFineGrainedTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager ecm;
    final Key key = new Key("key");
    final Person value = new Person("value");

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers(this.ecm);
        this.ecm = null;
    }

    public void testStoreAsBinaryOnBoth() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.memory().storageType(StorageType.BINARY).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, c);
        this.ecm.getCache().put((Object)this.key, (Object)this.value);
        DataConversion keyDataConversion = this.ecm.getCache().getAdvancedCache().getKeyDataConversion();
        DataConversion valueDataConversion = this.ecm.getCache().getAdvancedCache().getValueDataConversion();
        DataContainer dc = this.ecm.getCache().getAdvancedCache().getDataContainer();
        InternalCacheEntry entry = (InternalCacheEntry)dc.iterator().next();
        Object key = entry.getKey();
        Object value = entry.getValue();
        AssertJUnit.assertTrue((boolean)(key instanceof WrappedBytes));
        AssertJUnit.assertEquals((Object)keyDataConversion.fromStorage(key), (Object)this.key);
        AssertJUnit.assertTrue((boolean)(value instanceof WrappedBytes));
        AssertJUnit.assertEquals((Object)valueDataConversion.fromStorage(value), (Object)this.value);
    }
}

