/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.AdvancedExternalizerTest")
public class AdvancedExternalizerTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalCfg1 = this.createForeignExternalizerGlobalConfig();
        GlobalConfigurationBuilder globalCfg2 = this.createForeignExternalizerGlobalConfig();
        ConfigurationBuilder cfg = AdvancedExternalizerTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(globalCfg1, cfg);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(globalCfg2, cfg);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        this.defineConfigurationOnAllManagers(this.getCacheName(), cfg);
        this.waitForClusterToForm(this.getCacheName());
    }

    protected String getCacheName() {
        return "ForeignExternalizers";
    }

    protected GlobalConfigurationBuilder createForeignExternalizerGlobalConfig() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder().clusteredDefault();
        builder.serialization().addAdvancedExternalizer(1234, (AdvancedExternalizer)new IdViaConfigObj.Externalizer()).addAdvancedExternalizer((AdvancedExternalizer)new IdViaAnnotationObj.Externalizer()).addAdvancedExternalizer(3456, (AdvancedExternalizer)new IdViaBothObj.Externalizer());
        return builder;
    }

    public void testReplicatePojosWithUserDefinedExternalizers(Method m) {
        Cache cache1 = this.manager(0).getCache(this.getCacheName());
        Cache cache2 = this.manager(1).getCache(this.getCacheName());
        IdViaConfigObj configObj = new IdViaConfigObj().setName("Galder");
        String key = "k-" + m.getName() + "-viaConfig";
        cache1.put((Object)key, (Object)configObj);
        assert (configObj.name.equals(((IdViaConfigObj)cache2.get((Object)key)).name));
        IdViaAnnotationObj annotationObj = new IdViaAnnotationObj().setDate(new Date(System.currentTimeMillis()));
        key = "k-" + m.getName() + "-viaAnnotation";
        cache1.put((Object)key, (Object)annotationObj);
        assert (annotationObj.date.equals(((IdViaAnnotationObj)cache2.get((Object)key)).date));
        IdViaBothObj bothObj = new IdViaBothObj().setAge(30);
        key = "k-" + m.getName() + "-viaBoth";
        cache1.put((Object)key, (Object)bothObj);
        assert (bothObj.age == ((IdViaBothObj)cache2.get((Object)key)).age);
    }

    public static class IdViaConfigObj {
        String name;

        public IdViaConfigObj setName(String name) {
            this.name = name;
            return this;
        }

        public static class Externalizer
        extends AbstractExternalizer<IdViaConfigObj> {
            public void writeObject(ObjectOutput output, IdViaConfigObj object) throws IOException {
                output.writeUTF(object.name);
            }

            public IdViaConfigObj readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new IdViaConfigObj().setName(input.readUTF());
            }

            public Set<Class<? extends IdViaConfigObj>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{IdViaConfigObj.class});
            }
        }
    }

    public static class IdViaAnnotationObj {
        Date date;

        public IdViaAnnotationObj setDate(Date date) {
            this.date = date;
            return this;
        }

        public static class Externalizer
        extends AbstractExternalizer<IdViaAnnotationObj> {
            public void writeObject(ObjectOutput output, IdViaAnnotationObj object) throws IOException {
                output.writeObject(object.date);
            }

            public IdViaAnnotationObj readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new IdViaAnnotationObj().setDate((Date)input.readObject());
            }

            public Integer getId() {
                return 5678;
            }

            public Set<Class<? extends IdViaAnnotationObj>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{IdViaAnnotationObj.class});
            }
        }
    }

    public static class IdViaBothObj {
        int age;

        public IdViaBothObj setAge(int age) {
            this.age = age;
            return this;
        }

        public static class Externalizer
        extends AbstractExternalizer<IdViaBothObj> {
            public void writeObject(ObjectOutput output, IdViaBothObj object) throws IOException {
                output.writeInt(object.age);
            }

            public IdViaBothObj readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new IdViaBothObj().setAge(input.readInt());
            }

            public Integer getId() {
                return 9012;
            }

            public Set<Class<? extends IdViaBothObj>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{IdViaBothObj.class});
            }
        }
    }
}

