/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="manager.CacheDependencyTest")
@CleanupAfterMethod
public class CacheDependencyTest
extends SingleCacheManagerTest {
    @Test
    public void testExplicitStop() {
        this.cacheManager.defineConfiguration("A", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("B", new ConfigurationBuilder().build());
        Cache cacheA = this.cacheManager.getCache("A");
        Cache cacheB = this.cacheManager.getCache("B");
        this.cacheManager.addCacheDependency("A", "B");
        cacheB.stop();
        cacheA.stop();
        this.assertAllTerminated(cacheA, cacheB);
    }

    @Test
    public void testDependencyOnStoppedCaches() {
        this.cacheManager.defineConfiguration("A", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("B", new ConfigurationBuilder().build());
        Cache cacheA = this.cacheManager.getCache("A");
        Cache cacheB = this.cacheManager.getCache("B");
        cacheA.stop();
        this.cacheManager.addCacheDependency("A", "B");
        CacheEventListener listener = new CacheEventListener();
        this.cacheManager.addListener((Object)listener);
        this.cacheManager.stop();
        this.assertAllTerminated(cacheA, cacheB);
        AssertJUnit.assertEquals(Arrays.asList("B", "org.infinispan.CONFIG", this.getDefaultCacheName()), listener.stopOrder);
    }

    @Test
    public void testCyclicDependencies() {
        this.cacheManager.defineConfiguration("A", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("B", new ConfigurationBuilder().build());
        Cache cacheA = this.cacheManager.getCache("A");
        Cache cacheB = this.cacheManager.getCache("B");
        this.cacheManager.addCacheDependency("A", "B");
        this.cacheManager.addCacheDependency("B", "A");
        this.cacheManager.stop();
        this.assertAllTerminated(cacheA, cacheB);
    }

    @Test
    public void testStopCacheManager() {
        CacheEventListener listener = new CacheEventListener();
        this.cacheManager.addListener((Object)listener);
        this.cacheManager.defineConfiguration("A", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("B", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("C", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("D", new ConfigurationBuilder().build());
        Cache cacheA = this.cacheManager.getCache("A");
        Cache cacheB = this.cacheManager.getCache("B");
        Cache cacheC = this.cacheManager.getCache("C");
        Cache cacheD = this.cacheManager.getCache("D");
        this.cacheManager.addCacheDependency("A", "B");
        this.cacheManager.addCacheDependency("A", "C");
        this.cacheManager.addCacheDependency("A", "D");
        this.cacheManager.addCacheDependency("B", "C");
        this.cacheManager.addCacheDependency("B", "D");
        this.cacheManager.addCacheDependency("D", "C");
        this.cacheManager.stop();
        this.assertAllTerminated(cacheA, cacheB, cacheC, cacheD);
        AssertJUnit.assertEquals(Arrays.asList("A", "B", "D", "C", "org.infinispan.CONFIG", this.getDefaultCacheName()), listener.stopOrder);
    }

    @Test
    public void testRemoveCache() {
        this.cacheManager.defineConfiguration("A", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("B", new ConfigurationBuilder().build());
        this.cacheManager.defineConfiguration("C", new ConfigurationBuilder().build());
        Cache cacheA = this.cacheManager.getCache("A");
        Cache cacheB = this.cacheManager.getCache("B");
        Cache cacheC = this.cacheManager.getCache("C");
        this.cacheManager.addCacheDependency("A", "B");
        this.cacheManager.addCacheDependency("A", "C");
        this.cacheManager.addCacheDependency("B", "C");
        this.cacheManager.administration().removeCache("B");
        CacheEventListener listener = new CacheEventListener();
        this.cacheManager.addListener((Object)listener);
        this.cacheManager.stop();
        this.assertAllTerminated(cacheA, cacheB, cacheC);
        AssertJUnit.assertEquals(Arrays.asList("A", "C", "org.infinispan.CONFIG", this.getDefaultCacheName()), listener.stopOrder);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder());
    }

    private void assertAllTerminated(Cache<?, ?> ... caches) {
        for (Cache<?, ?> cache : caches) {
            assert (cache.getStatus() == ComponentStatus.TERMINATED);
        }
    }

    @Listener
    private static final class CacheEventListener {
        private final List<String> stopOrder = new ArrayList<String>();

        private CacheEventListener() {
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent cse) {
            this.stopOrder.add(cse.getCacheName());
        }
    }
}

