/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestBlocking;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestClassLocal;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.SerializableRunnable;
import org.infinispan.util.function.SerializableSupplier;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="manager.AllClusterExecutorTest")
public class AllClusterExecutorTest
extends AbstractInfinispanTest {
    static AtomicInteger atomicInteger = new AtomicInteger();
    private final TestClassLocal<CheckPoint> checkPoint = new TestClassLocal<CheckPoint>("checkpoint", this, CheckPoint::new, c -> {});
    SerializableSupplier<AtomicInteger> atomicIntegerSupplier = (SerializableSupplier & Serializable)() -> atomicInteger;

    ClusterExecutor executor(EmbeddedCacheManager cm) {
        return cm.executor();
    }

    void assertSize(EmbeddedCacheManager[] cms, int receivedSize) {
        AssertJUnit.assertEquals((int)cms.length, (int)receivedSize);
    }

    void eventuallyAssertSize(EmbeddedCacheManager[] cms, Supplier<Integer> supplier) {
        this.eventuallyEquals(cms.length, supplier);
    }

    void assertContains(EmbeddedCacheManager[] managers, Collection<Address> results) {
        for (EmbeddedCacheManager manager : managers) {
            AssertJUnit.assertTrue((boolean)results.contains(manager.getAddress()));
        }
    }

    public void testExecutorRunnable() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).set(0);
                SerializableSupplier<AtomicInteger> supplier = AllClusterExecutorTest.this.atomicIntegerSupplier;
                AllClusterExecutorTest.this.executor(cm1).submit((SerializableRunnable & Serializable)() -> ((AtomicInteger)supplier.get()).getAndIncrement()).get(10L, TimeUnit.SECONDS);
                AllClusterExecutorTest.this.assertSize(this.cms, ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).get());
            }
        });
    }

    public void testExecutorLocalRunnable() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.LOCAL, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).set(0);
                SerializableSupplier<AtomicInteger> supplier = AllClusterExecutorTest.this.atomicIntegerSupplier;
                AllClusterExecutorTest.this.executor(cm1).submit((SerializableRunnable & Serializable)() -> ((AtomicInteger)supplier.get()).getAndIncrement()).get(10L, TimeUnit.SECONDS);
                AllClusterExecutorTest.this.assertSize(this.cms, ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).get());
            }
        });
    }

    public void testExecutor3NodesRunnable() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).set(0);
                SerializableSupplier<AtomicInteger> supplier = AllClusterExecutorTest.this.atomicIntegerSupplier;
                AllClusterExecutorTest.this.executor(cm1).submit((SerializableRunnable & Serializable)() -> ((AtomicInteger)supplier.get()).getAndIncrement()).get(10L, TimeUnit.SECONDS);
                AllClusterExecutorTest.this.assertSize(this.cms, ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).get());
            }
        });
    }

    public void testExecutorRunnablePredicateFilter() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).set(0);
                SerializableSupplier<AtomicInteger> supplier = AllClusterExecutorTest.this.atomicIntegerSupplier;
                AllClusterExecutorTest.this.executor(cm1).filterTargets(a -> a.equals((Object)cm1.getAddress())).submit((SerializableRunnable & Serializable)() -> ((AtomicInteger)supplier.get()).getAndIncrement()).get(10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((int)1, (int)((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).get());
            }
        });
    }

    public void testExecutorRunnableCollectionFilter() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                EmbeddedCacheManager cm2 = this.cms[1];
                ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).set(0);
                SerializableSupplier<AtomicInteger> supplier = AllClusterExecutorTest.this.atomicIntegerSupplier;
                AllClusterExecutorTest.this.executor(cm1).filterTargets(Collections.singleton(cm2.getAddress())).submit((SerializableRunnable & Serializable)() -> ((AtomicInteger)supplier.get()).getAndIncrement()).get(10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((int)1, (int)((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).get());
            }
        });
    }

    public void testExecutorRunnableException() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).submit((SerializableRunnable & Serializable)() -> {
                    throw new TestException();
                });
                Exceptions.expectExecutionException(TestException.class, (Future)future);
            }
        });
    }

    public void testExecutorRunnableExceptionWhenComplete() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).submit((SerializableRunnable & Serializable)() -> {
                    throw new TestException();
                });
                Exchanger<Object> exchanger = new Exchanger<Object>();
                future.whenCompleteAsync((v, t) -> {
                    try {
                        exchanger.exchange(t, 10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | java.util.concurrent.TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }, (Executor)TestingUtil.extractGlobalComponent((CacheContainer)cm1, ExecutorService.class, "org.infinispan.executors.blocking"));
                Throwable t2 = exchanger.exchange(null, 10L, TimeUnit.SECONDS);
                AssertJUnit.assertNotNull((Object)t2);
                AssertJUnit.assertEquals(TestException.class, t2.getClass());
            }
        });
    }

    public void testExecutorRunnable3NodesException() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).submit((SerializableRunnable & Serializable)() -> {
                    throw new TestException();
                });
                Exceptions.expectExecutionException(TestException.class, (Future)future);
            }
        });
    }

    public void testExecutorRunnable3NodesExceptionExcludeLocal() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).filterTargets(a -> !a.equals((Object)cm1.getAddress())).submit((SerializableRunnable & Serializable)() -> {
                    throw new TestException();
                });
                Exceptions.expectExecutionException(TestException.class, (Future)future);
            }
        });
    }

    public void testExecutorTimeoutException() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.DIST_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.DIST_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                TestClassLocal<CheckPoint> checkPoint = AllClusterExecutorTest.this.checkPoint;
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).timeout(1L, TimeUnit.MILLISECONDS).submit((SerializableRunnable & Serializable)() -> {
                    try {
                        ((CheckPoint)checkPoint.get()).awaitStrict("resume_remote_execution", 10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | java.util.concurrent.TimeoutException e) {
                        throw new TestException(e);
                    }
                });
                Exceptions.expectExecutionException(TimeoutException.class, (Future)future);
                checkPoint.get().trigger("resume_remote_execution");
            }
        });
    }

    public void testExecutorExecuteRunnable() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).set(0);
                SerializableSupplier<AtomicInteger> supplier = AllClusterExecutorTest.this.atomicIntegerSupplier;
                AllClusterExecutorTest.this.executor(cm1).execute((SerializableRunnable & Serializable)() -> ((AtomicInteger)supplier.get()).getAndIncrement());
                AllClusterExecutorTest.this.eventuallyAssertSize(this.cms, () -> ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).get());
            }
        });
    }

    public void testExecutorLocalExecuteRunnable() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.LOCAL, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).set(0);
                AllClusterExecutorTest.this.executor(cm1).execute((SerializableRunnable & Serializable)() -> ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).getAndIncrement());
                AllClusterExecutorTest.this.eventuallyEquals(1, () -> ((AtomicInteger)AllClusterExecutorTest.this.atomicIntegerSupplier.get()).get());
            }
        });
    }

    public void testExecutorTriConsumer() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                EmbeddedCacheManager cm2 = this.cms[1];
                AtomicReference throwable = new AtomicReference();
                List<Address> addresses = Collections.synchronizedList(new ArrayList(2));
                AllClusterExecutorTest.this.executor(cm1).submitConsumer(EmbeddedCacheManager::getAddress, (a, i, t) -> {
                    if (t != null) {
                        throwable.set(t);
                    } else {
                        addresses.add((Address)i);
                    }
                }).get(10L, TimeUnit.SECONDS);
                Throwable t2 = (Throwable)throwable.get();
                if (t2 != null) {
                    throw new RuntimeException(t2);
                }
                AllClusterExecutorTest.this.assertContains(this.cms, addresses);
            }
        });
    }

    public void testExecutorLocalTriConsumer() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.LOCAL, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                AtomicReference throwable = new AtomicReference();
                List addresses = Collections.synchronizedList(new ArrayList(2));
                AllClusterExecutorTest.this.executor(cm1).submitConsumer((SerializableFunction & Serializable)m -> m.getAddress(), (a, i, t) -> {
                    if (t != null) {
                        throwable.set(t);
                    } else {
                        addresses.add(i);
                    }
                }).get(10L, TimeUnit.SECONDS);
                Throwable t2 = (Throwable)throwable.get();
                if (t2 != null) {
                    throw new RuntimeException(t2);
                }
                AssertJUnit.assertEquals((int)1, (int)addresses.size());
                AssertJUnit.assertTrue((boolean)addresses.contains(cm1.getAddress()));
            }
        });
    }

    public void testExecutor3NodeTriConsumer() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.DIST_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.DIST_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.DIST_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                AtomicReference throwable = new AtomicReference();
                List<Address> addresses = Collections.synchronizedList(new ArrayList(2));
                AllClusterExecutorTest.this.executor(cm1).submitConsumer((SerializableFunction & Serializable)m -> m.getAddress(), (a, i, t) -> {
                    if (t != null) {
                        throwable.set(t);
                    } else {
                        addresses.add((Address)i);
                    }
                }).get(10L, TimeUnit.SECONDS);
                Throwable t2 = (Throwable)throwable.get();
                if (t2 != null) {
                    throw new RuntimeException(t2);
                }
                AllClusterExecutorTest.this.assertContains(this.cms, addresses);
            }
        });
    }

    public void testExecutorTriConsumerException() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                AtomicInteger exceptionCount = new AtomicInteger();
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).submitConsumer((SerializableFunction & Serializable)m -> {
                    throw new TestException();
                }, (a, i, t) -> {
                    Exceptions.assertException(TestException.class, (Throwable)t);
                    exceptionCount.incrementAndGet();
                });
                future.get(10L, TimeUnit.SECONDS);
                AllClusterExecutorTest.this.assertSize(this.cms, exceptionCount.get());
            }
        });
    }

    public void testExecutorTriConsumerTimeoutException() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.DIST_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.DIST_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                TestClassLocal<CheckPoint> checkPoint = AllClusterExecutorTest.this.checkPoint;
                SerializableFunction & Serializable blockingFunction = (SerializableFunction & Serializable)m -> {
                    try {
                        ((CheckPoint)checkPoint.get()).trigger("block_execution");
                        ((CheckPoint)checkPoint.get()).awaitStrict("resume_execution", 10L, TimeUnit.SECONDS);
                        ((CheckPoint)checkPoint.get()).trigger("complete");
                    }
                    catch (InterruptedException | java.util.concurrent.TimeoutException e) {
                        throw new TestException(e);
                    }
                    return null;
                };
                CompletableFuture futureRemote = AllClusterExecutorTest.this.executor(cm1).filterTargets(a -> !a.equals((Object)cm1.getAddress())).timeout(1L, TimeUnit.MILLISECONDS).submitConsumer((SerializableFunction)blockingFunction, (a, i, t) -> log.tracef("Consumer invoked with %s, %s, %s", a, i, t));
                Exceptions.expectExecutionException(TimeoutException.class, (Future)futureRemote);
                checkPoint.get().awaitStrict("block_execution", 10L, TimeUnit.SECONDS);
                checkPoint.get().trigger("resume_execution");
                checkPoint.get().awaitStrict("complete", 10L, TimeUnit.SECONDS);
                CompletableFuture futureLocal = AllClusterExecutorTest.this.executor(cm1).filterTargets(a -> a.equals((Object)cm1.getAddress())).timeout(1L, TimeUnit.MILLISECONDS).submitConsumer((SerializableFunction)blockingFunction, (a, i, t) -> log.tracef("Consumer invoked with %s, %s, %s", a, i, t));
                Exceptions.expectExecutionException(TimeoutException.class, (Future)futureLocal);
                checkPoint.get().awaitStrict("block_execution", 10L, TimeUnit.SECONDS);
                checkPoint.get().trigger("resume_execution");
                checkPoint.get().awaitStrict("complete", 10L, TimeUnit.SECONDS);
            }
        });
    }

    public void testExecutorTriConsumerExceptionFromConsumer() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).submitConsumer((SerializableFunction & Serializable)m -> null, (a, i, t) -> {
                    throw new NullPointerException();
                });
                Exceptions.expectExecutionException(NullPointerException.class, (Future)future);
            }
        });
    }

    public void testExecutorTriConsumerExceptionWhenComplete() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
                EmbeddedCacheManager cm1 = this.cms[0];
                CompletableFuture future = AllClusterExecutorTest.this.executor(cm1).filterTargets(arg_0 -> ((Address)cm1.getAddress()).equals(arg_0)).submitConsumer((SerializableFunction & Serializable)m -> null, (a, i, t) -> {
                    throw new NullPointerException();
                });
                Exchanger<Object> exchanger = new Exchanger<Object>();
                future.whenCompleteAsync((v, t) -> {
                    try {
                        TestBlocking.exchange(exchanger, t, 10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | java.util.concurrent.TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }, (Executor)TestingUtil.extractGlobalComponent((CacheContainer)cm1, ExecutorService.class, "org.infinispan.executors.blocking"));
                Throwable t2 = exchanger.exchange(null, 10L, TimeUnit.SECONDS);
                AssertJUnit.assertNotNull((Object)t2);
                AssertJUnit.assertEquals(NullPointerException.class, t2.getClass());
            }
        });
    }
}

