/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.ClusterExecutionPolicy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.function.SerializableRunnable;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="manager.AllClusterExecutorExecutionPolicyTest")
public class AllClusterExecutorExecutionPolicyTest
extends MultipleCacheManagersTest {
    private static final AtomicInteger actualInvocations = new AtomicInteger();

    public String toString() {
        return super.toString();
    }

    @DataProvider(name="params")
    public Object[][] dataProvider() {
        return new Object[][]{{ClusterExecutionPolicy.ALL, 0, 0, 0, 25}, {ClusterExecutionPolicy.ALL, 2, 1, 1, 25}, {ClusterExecutionPolicy.DIFFERENT_MACHINE, 1, 0, 1, 24}, {ClusterExecutionPolicy.DIFFERENT_MACHINE, 0, 1, 4, 24}, {ClusterExecutionPolicy.SAME_MACHINE, 2, 1, 1, 1}, {ClusterExecutionPolicy.SAME_MACHINE, 0, 0, 1, 1}, {ClusterExecutionPolicy.DIFFERENT_RACK, 2, 2, 3, 21}, {ClusterExecutionPolicy.DIFFERENT_RACK, 1, 0, 1, 21}, {ClusterExecutionPolicy.DIFFERENT_RACK, 0, 1, 4, 18}, {ClusterExecutionPolicy.SAME_RACK, 2, 1, 1, 2}, {ClusterExecutionPolicy.SAME_RACK, 1, 0, 1, 4}, {ClusterExecutionPolicy.SAME_RACK, 0, 2, 0, 1}, {ClusterExecutionPolicy.DIFFERENT_SITE, 2, 0, 4, 14}, {ClusterExecutionPolicy.DIFFERENT_SITE, 1, 0, 3, 21}, {ClusterExecutionPolicy.DIFFERENT_SITE, 0, 1, 6, 15}, {ClusterExecutionPolicy.SAME_SITE, 2, 0, 2, 11}, {ClusterExecutionPolicy.SAME_SITE, 1, 0, 0, 4}, {ClusterExecutionPolicy.SAME_SITE, 0, 1, 4, 10}};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        int[][] topology = new int[][]{{2, 7, 1}, {4}, {5, 2, 4}};
        for (int siteNumber = 0; siteNumber < topology.length; ++siteNumber) {
            int[] racksForSite = topology[siteNumber];
            for (int rackNumber = 0; rackNumber < racksForSite.length; ++rackNumber) {
                int machines = racksForSite[rackNumber];
                for (int machineNumber = 0; machineNumber < machines; ++machineNumber) {
                    ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
                    GlobalConfigurationBuilder globalConfigurationBuilder = holder.getGlobalConfigurationBuilder().clusteredDefault();
                    globalConfigurationBuilder.transport().machineId(String.valueOf(machineNumber)).rackId(String.valueOf(rackNumber)).siteId(String.valueOf(siteNumber));
                    this.addClusterEnabledCacheManager(holder);
                }
            }
        }
    }

    @Test(dataProvider="params")
    public void runTest(ClusterExecutionPolicy policy, int site, int rack, int machine, int invocationCount) throws InterruptedException, ExecutionException, TimeoutException {
        actualInvocations.set(0);
        EmbeddedCacheManager cacheManager = this.cacheManagers.stream().filter(cm -> {
            TransportConfiguration tc = cm.getCacheManagerConfiguration().transport();
            return Integer.valueOf(tc.siteId()) == site && Integer.valueOf(tc.rackId()) == rack && Integer.valueOf(tc.machineId()) == machine;
        }).findFirst().orElseThrow(() -> new AssertionError((Object)("No cache manager matches site: " + site + " rack: " + rack + " machine: " + machine)));
        cacheManager.executor().filterTargets(policy).submit((SerializableRunnable & Serializable)() -> actualInvocations.incrementAndGet()).get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)invocationCount, (int)actualInvocations.get());
    }
}

