/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.replicated.optimistic;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="lock.singlelock.replicated.optimistic.InitiatorCrashOptimisticReplTest", description="See ISPN-2161 -- original group: functional")
@CleanupAfterMethod
public class InitiatorCrashOptimisticReplTest
extends AbstractCrashTest {
    public InitiatorCrashOptimisticReplTest() {
        super(CacheMode.REPL_SYNC, LockingMode.OPTIMISTIC, false);
    }

    public InitiatorCrashOptimisticReplTest(CacheMode mode, LockingMode locking, boolean useSync) {
        super(mode, locking, useSync);
    }

    public void testInitiatorNodeCrashesBeforeCommit() throws Exception {
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        txControlInterceptor.prepareProgress.countDown();
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)txControlInterceptor, 1);
        Future<Void> future = this.beginAndCommitTx("k", 1);
        txControlInterceptor.commitReceived.await();
        this.assertLocked(this.cache(0), (Object)"k");
        this.assertEventuallyNotLocked(this.cache(1), "k");
        this.assertEventuallyNotLocked(this.cache(2), "k");
        this.checkTxCount(0, 0, 1);
        this.checkTxCount(1, 1, 0);
        this.checkTxCount(2, 0, 1);
        this.killMember(1);
        this.assertNotLocked("k");
        InitiatorCrashOptimisticReplTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        future.get(30L, TimeUnit.SECONDS);
    }

    public void testInitiatorCrashesBeforeReleasingLock() throws Exception {
        CountDownLatch releaseLocksLatch = new CountDownLatch(1);
        this.skipTxCompletion(this.advancedCache(1), releaseLocksLatch);
        Future<Void> future = this.beginAndCommitTx("k", 1);
        releaseLocksLatch.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 0, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.assertLocked(this.cache(0), (Object)"k");
        this.assertEventuallyNotLocked(this.cache(1), "k");
        this.assertEventuallyNotLocked(this.cache(2), "k");
        this.killMember(1);
        InitiatorCrashOptimisticReplTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        this.assertNotLocked("k");
        assert (this.cache(0).get((Object)"k").equals("v"));
        assert (this.cache(1).get((Object)"k").equals("v"));
        future.get(30L, TimeUnit.SECONDS);
    }

    public void testInitiatorNodeCrashesBeforePrepare() throws Exception {
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)txControlInterceptor, 1);
        Future<Void> future = this.beginAndPrepareTx("k", 1);
        txControlInterceptor.preparedReceived.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 1, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.killMember(1);
        assert (this.caches().size() == 2);
        txControlInterceptor.prepareProgress.countDown();
        this.assertNotLocked("k");
        InitiatorCrashOptimisticReplTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        future.get(30L, TimeUnit.SECONDS);
    }
}

