/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.optimistic;

import jakarta.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.lock.singlelock.AbstractLockOwnerCrashTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.optimistic.LockOwnerCrashOptimisticTest")
@CleanupAfterMethod
public class LockOwnerCrashOptimisticTest
extends AbstractLockOwnerCrashTest {
    private EmbeddedTransaction transaction;

    public LockOwnerCrashOptimisticTest() {
        super(CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, false);
    }

    public void testLockOwnerCrashesBeforePrepare() throws Exception {
        Object k = this.getKeyForCache(2);
        this.inNewThread(() -> {
            try {
                this.tm(1).begin();
                this.cache(1).put(k, (Object)"v");
                this.transaction = (EmbeddedTransaction)this.tm(1).getTransaction();
            }
            catch (Throwable e) {
                log.errorf(e, "Error starting transaction for key %s", k);
            }
        });
        LockOwnerCrashOptimisticTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 0));
        this.killMember(2);
        assert (this.caches().size() == 2);
        this.tm(1).resume((Transaction)this.transaction);
        this.tm(1).commit();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(0).get(k));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get(k));
        this.assertNotLocked(k);
        LockOwnerCrashOptimisticTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
    }

    public void lockOwnerCrasherBetweenPrepareAndCommit() throws Exception {
        Object k = this.getKeyForCache(2);
        this.inNewThread(() -> {
            try {
                this.tm(1).begin();
                this.cache(1).put(k, (Object)"v");
                this.transaction = (EmbeddedTransaction)this.tm(1).getTransaction();
                this.transaction.runPrepare();
            }
            catch (Throwable e) {
                log.errorf(e, "Error preparing transaction for key %s", k);
            }
        });
        LockOwnerCrashOptimisticTest.eventually(() -> this.checkTxCount(0, 0, 1) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 1));
        this.killMember(2);
        assert (this.caches().size() == 2);
        this.tm(1).begin();
        this.cache(1).put(k, (Object)"v3");
        try {
            this.tm(1).commit();
            AssertJUnit.fail((String)("Exception expected as lock cannot be acquired on k=" + String.valueOf(k)));
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Expected error committing transaction for key %s", k);
        }
        this.tm(0).begin();
        this.cache(0).put(k, (Object)"v2");
        try {
            this.tm(0).commit();
            AssertJUnit.fail((String)("Exception expected as lock cannot be acquired on k=" + String.valueOf(k)));
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Expected error committing transaction for key %s", k);
        }
        this.tm(1).resume((Transaction)this.transaction);
        this.transaction.runPrepare();
    }
}

