/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import jakarta.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.ExplicitUnlockTest")
@CleanupAfterMethod
public class ExplicitUnlockTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(ExplicitUnlockTest.class);
    private static final int NUMBER_OF_KEYS = 10;

    public void testLock() throws Exception {
        this.doTestLock(true, 10);
    }

    public void testLockTwoTasks() throws Exception {
        this.doTestLock(true, 2);
    }

    public void testLockNoExplicitUnlock() throws Exception {
        this.doTestLock(false, 10);
    }

    public void testLockNoExplicitUnlockTwoTasks() throws Exception {
        this.doTestLock(false, 10);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    private void doTestLock(boolean withUnlock, int nThreads) throws Exception {
        for (int key = 1; key <= 10; ++key) {
            this.cache.put((Object)("" + key), (Object)"value");
        }
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(nThreads);
        for (int i = 1; i <= nThreads; ++i) {
            results.add(this.fork(new Worker(i, (Cache<Object, Object>)this.cache, withUnlock, 10L)));
        }
        boolean success = true;
        for (Future future : results) {
            success = success && (Boolean)future.get(30L, TimeUnit.SECONDS) != false;
        }
        AssertJUnit.assertTrue((String)"All worker should complete without exceptions", (boolean)success);
        this.assertNoTransactions();
        for (int i = 0; i < 10; ++i) {
            this.assertEventuallyNotLocked(this.cache, String.valueOf(i));
        }
    }

    private static class Worker
    implements Callable<Boolean> {
        private static final String lockKey = "0";
        private final Cache<Object, Object> cache;
        private final boolean withUnlock;
        private final long stepDelayMsec;
        private final int index;

        public Worker(int index, Cache<Object, Object> cache, boolean withUnlock, long stepDelayMsec) {
            this.index = index;
            this.cache = cache;
            this.withUnlock = withUnlock;
            this.stepDelayMsec = stepDelayMsec;
        }

        @Override
        public Boolean call() throws Exception {
            boolean success;
            try {
                this.doRun();
                success = true;
            }
            catch (Throwable t) {
                log.errorf(t, "Error in Worker[%s, unlock? %s]", (Object)this.index, (Object)this.withUnlock);
                success = false;
            }
            return success;
        }

        private void log(String method, String msg) {
            log.debugf("Worker[%s, unlock? %s] %s %s", new Object[]{this.index, this.withUnlock, method, msg});
        }

        private void doRun() throws Exception {
            String methodName = "run";
            TransactionManager mgr = this.cache.getAdvancedCache().getTransactionManager();
            if (null == mgr) {
                throw new UnsupportedOperationException("TransactionManager was not configured for the cache " + this.cache.getName());
            }
            mgr.begin();
            try {
                if (this.acquireLock()) {
                    this.log("run", "acquired lock");
                    String newName = "value-" + this.index;
                    this.log("run", "Changing value to " + newName);
                    for (int key = 1; key <= 10; ++key) {
                        this.cache.put((Object)String.valueOf(key), (Object)newName);
                        Thread.sleep(this.stepDelayMsec);
                    }
                    this.validateCache();
                    if (this.withUnlock) {
                        this.unlock();
                    }
                } else {
                    this.log("run", "Failed to acquired lock");
                }
                mgr.commit();
            }
            catch (Exception t) {
                mgr.rollback();
                throw t;
            }
        }

        private boolean acquireLock() {
            return this.cache.getAdvancedCache().lock(new Object[]{lockKey});
        }

        private void unlock() {
            LockManager lockManager = this.cache.getAdvancedCache().getLockManager();
            Object lockOwner = lockManager.getOwner((Object)lockKey);
            lockManager.unlock((Object)lockKey, lockOwner);
        }

        private void validateCache() throws InterruptedException {
            String value = this.getCachedValue(1);
            for (int key = 1; key <= 10; ++key) {
                String nextValue = this.getCachedValue(key);
                if (!value.equals(nextValue)) {
                    String msg = String.format("Cache inconsistent: value=%s, nextValue=%s", value, nextValue);
                    this.log("validate_cache", msg);
                    throw new ConcurrentModificationException(msg);
                }
                Thread.sleep(this.stepDelayMsec);
            }
            this.log("validate_cache", "passed: " + value);
        }

        private String getCachedValue(int index) {
            String value = (String)this.cache.get((Object)String.valueOf(index));
            if (null == value) {
                throw new ConcurrentModificationException("Missed entry for " + index);
            }
            return value;
        }
    }
}

