/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CustomMBeanServerPropertiesTest")
public class CustomMBeanServerPropertiesTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeclarativeCustomMBeanServerLookupProperties() {
        String cfg = "<infinispan><cache-container default-cache=\"default\"><jmx enabled=\"true\" mbean-server-lookup=\"" + TestLookup.class.getName() + "\"><property name=\"key\">value</property></jmx><local-cache name=\"default\"/></cache-container></infinispan>";
        ByteArrayInputStream stream = new ByteArrayInputStream(cfg.getBytes());
        EmbeddedCacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromStream(stream);
            cm.getCache();
            MBeanServerLookup mbsl = cm.getCacheManagerConfiguration().jmx().mbeanServerLookup();
            AssertJUnit.assertTrue((boolean)(mbsl instanceof TestLookup));
            AssertJUnit.assertEquals((Object)"value", (Object)((TestLookup)mbsl).props.get("key"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProgrammaticCustomMBeanServerLookupProperties() {
        EmbeddedCacheManager cm = null;
        try {
            GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
            TestLookup mbsl = new TestLookup();
            gc.jmx().enabled(true).mBeanServerLookup((MBeanServerLookup)mbsl).addProperty("key", "value");
            ConfigurationBuilder cfg = new ConfigurationBuilder();
            cm = TestCacheManagerFactory.createCacheManager(gc, cfg);
            cm.getCache();
            AssertJUnit.assertEquals((Object)"value", (Object)mbsl.props.get("key"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public static final class TestLookup
    implements MBeanServerLookup {
        Properties props;
        private final MBeanServer mBeanServer = MBeanServerFactory.newMBeanServer();

        public MBeanServer getMBeanServer(Properties props) {
            this.props = props;
            return this.mBeanServer;
        }
    }
}

