/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheOpsTest")
public class CacheOpsTest
extends SingleCacheManagerTest {
    private static final String JMX_DOMAIN = CacheOpsTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        cfg.transaction().autoCommit(false).memory().size(1000L);
        return TestCacheManagerFactory.createCacheManager(gcb, cfg);
    }

    public void testClear() throws Exception {
        ObjectName cacheObjectName = TestingUtil.getCacheObjectName(JMX_DOMAIN, this.getDefaultCacheName() + "(local)");
        this.tm().begin();
        this.cache().put((Object)"k", (Object)"v");
        this.tm().commit();
        AssertJUnit.assertFalse((boolean)this.cache().isEmpty());
        this.mBeanServerLookup.getMBeanServer().invoke(cacheObjectName, "clear", new Object[0], new String[0]);
        AssertJUnit.assertTrue((boolean)this.cache().isEmpty());
    }
}

