/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ActivationAndPassivationInterceptorMBeanTest")
public class ActivationAndPassivationInterceptorMBeanTest
extends SingleCacheManagerTest {
    private static final String JMX_DOMAIN = ActivationAndPassivationInterceptorMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private DummyInMemoryStore loader;
    private ObjectName activationInterceptorObjName;
    private ObjectName passivationInterceptorObjName;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        globalBuilder.jmx().enabled(true).mBeanServerLookup(this.mBeanServerLookup).domain(JMX_DOMAIN);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(1L).statistics().enable().persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class);
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.activationInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, this.getDefaultCacheName() + "(local)", "Activation");
        this.passivationInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, this.getDefaultCacheName() + "(local)", "Passivation");
        this.loader = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
    }

    @AfterMethod
    public void resetStats() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        mBeanServer.invoke(this.activationInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
        mBeanServer.invoke(this.passivationInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
    }

    public void passivateAll() throws Exception {
        this.mBeanServerLookup.getMBeanServer().invoke(this.passivationInterceptorObjName, "passivateAll", new Object[0], new String[0]);
    }

    public void testDisableStatistics() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        mBeanServer.setAttribute(this.activationInterceptorObjName, new Attribute("StatisticsEnabled", Boolean.FALSE));
        assert (mBeanServer.getAttribute(this.activationInterceptorObjName, "Activations").toString().equals("N/A"));
        mBeanServer.setAttribute(this.activationInterceptorObjName, new Attribute("StatisticsEnabled", Boolean.TRUE));
    }

    public void testActivationOnGet(Method m) {
        this.assertActivationCount(0L);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0L);
        this.loader.write(MarshalledEntryUtil.create(TestingUtil.k(m), TestingUtil.v(m), this.cache));
        assert (this.loader.contains(TestingUtil.k(m)));
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m)));
        this.assertActivationCount(0L);
        assert (this.loader.contains(TestingUtil.k(m)));
    }

    public void testActivationOnPut(Method m) {
        this.assertActivationCount(0L);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0L);
        this.loader.write(MarshalledEntryUtil.create(TestingUtil.k(m), TestingUtil.v(m), this.cache));
        assert (this.loader.contains(TestingUtil.k(m)));
        this.cache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 2));
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m, 2)));
        this.assertActivationCount(0L);
        assert (this.loader.contains(TestingUtil.k(m)));
    }

    public void testActivationOnReplace(Method m) {
        this.assertActivationCount(0L);
        AssertJUnit.assertNull((Object)this.cache.get((Object)TestingUtil.k(m)));
        this.assertActivationCount(0L);
        this.loader.write(MarshalledEntryUtil.create(TestingUtil.k(m), TestingUtil.v(m), this.cache));
        AssertJUnit.assertTrue((boolean)this.loader.contains(TestingUtil.k(m)));
        Object prev = this.cache.replace((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 2));
        AssertJUnit.assertNotNull((Object)prev);
        AssertJUnit.assertEquals((Object)TestingUtil.v(m), (Object)prev);
        this.assertActivationCount(0L);
        AssertJUnit.assertTrue((boolean)this.loader.contains(TestingUtil.k(m)));
    }

    public void testActivationOnPutMap(Method m) {
        this.assertActivationCount(0L);
        AssertJUnit.assertNull((Object)this.cache.get((Object)TestingUtil.k(m)));
        this.assertActivationCount(0L);
        this.loader.write(MarshalledEntryUtil.create(TestingUtil.k(m), TestingUtil.v(m), this.cache));
        AssertJUnit.assertTrue((boolean)this.loader.contains(TestingUtil.k(m)));
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put(TestingUtil.k(m), TestingUtil.v(m, 2));
        this.cache.putAll(toAdd);
        this.assertActivationCount(0L);
        Object obj = this.cache.get((Object)TestingUtil.k(m));
        AssertJUnit.assertNotNull((Object)obj);
        AssertJUnit.assertEquals((Object)TestingUtil.v(m, 2), (Object)obj);
        AssertJUnit.assertTrue((boolean)this.loader.contains(TestingUtil.k(m)));
    }

    public void testPassivationOnEvict(Method m) throws Exception {
        this.assertPassivationCount(0L);
        this.cache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        this.cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
        this.cache.evict((Object)TestingUtil.k(m));
        this.assertPassivationCount(1L);
        this.cache.evict((Object)TestingUtil.k(m, 2));
        this.assertPassivationCount(2L);
        this.cache.evict((Object)"not_existing_key");
        this.assertPassivationCount(2L);
    }

    public void testPassivateAll(Method m) throws Exception {
        this.assertPassivationCount(0L);
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)TestingUtil.k(m, i), (Object)TestingUtil.v(m, i));
        }
        this.passivateAll();
        this.assertPassivationCount(9L);
    }

    private void assertActivationCount(long activationCount) {
        this.eventuallyEquals(activationCount, () -> {
            try {
                return Long.parseLong(this.mBeanServerLookup.getMBeanServer().getAttribute(this.activationInterceptorObjName, "Activations").toString());
            }
            catch (Exception e) {
                throw Util.rewrapAsCacheException((Throwable)e);
            }
        });
    }

    private void assertPassivationCount(long activationCount) throws Exception {
        long passivations = Long.parseLong(this.mBeanServerLookup.getMBeanServer().getAttribute(this.passivationInterceptorObjName, "Passivations").toString());
        AssertJUnit.assertEquals((long)activationCount, (long)passivations);
    }
}

