/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="invalidation.WriteStoreInvalidationTest")
public class WriteStoreInvalidationTest
extends MultipleCacheManagersTest {
    private static final String key = "key";
    private static final String value = "value";
    private static final String changedValue = "changed-value";
    private static final String cacheName = "inval-write-cache-store";
    private boolean transactional;

    @Override
    public WriteStoreInvalidationTest transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new WriteStoreInvalidationTest().transactional(true), new WriteStoreInvalidationTest().transactional(false)};
    }

    @Override
    protected String[] parameterNames() {
        return WriteStoreInvalidationTest.concat(super.parameterNames(), "transactional");
    }

    @Override
    protected Object[] parameterValues() {
        return WriteStoreInvalidationTest.concat(super.parameterValues(), this.transactional);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = WriteStoreInvalidationTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, this.transactional);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cb.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName(this.getClass().getSimpleName());
        this.createClusteredCaches(2, cacheName, cb);
    }

    @Test
    public void testSharedCacheStoreAfterInvalidation() {
        DummyInMemoryStore store0 = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache(0, cacheName));
        store0.clearStats();
        AssertJUnit.assertNull((Object)this.cache(0, cacheName).get((Object)key));
        this.assertStoreStats(store0, 1, 0, 0);
        this.advancedCache(0, cacheName).withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)key, (Object)value);
        this.assertStoreStats(store0, 1, 1, 0);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache(1, cacheName).get((Object)key));
        this.assertStoreStats(store0, 2, 1, 0);
        this.advancedCache(1, cacheName).withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)key, (Object)changedValue);
        this.assertStoreStats(store0, 2, 2, 0);
        AssertJUnit.assertFalse((boolean)this.cache(0, cacheName).getAdvancedCache().getDataContainer().containsKey((Object)key));
        AssertJUnit.assertEquals((Object)changedValue, (Object)this.cache(0, cacheName).get((Object)key));
        this.assertStoreStats(store0, 3, 2, 0);
    }

    public void testWriteAndRemoveOnVariousNodes() {
        Cache cache0 = this.cache(0, cacheName);
        Cache cache1 = this.cache(0, cacheName);
        AssertJUnit.assertNull((Object)cache0.put((Object)key, (Object)"foo"));
        AssertJUnit.assertEquals((String)"foo", (String)((String)cache1.get((Object)key)));
        AssertJUnit.assertEquals((String)"foo", (String)((String)cache1.put((Object)key, (Object)"bar")));
        AssertJUnit.assertEquals((String)"bar", (String)((String)cache0.get((Object)key)));
    }

    private void assertStoreStats(DummyInMemoryStore<String, String> store, int loads, int writes, int deletes) {
        AssertJUnit.assertEquals((int)loads, (int)store.stats().get("load"));
        AssertJUnit.assertEquals((int)writes, (int)store.stats().get("write"));
        AssertJUnit.assertEquals((int)deletes, (int)store.stats().get("delete"));
    }
}

