/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="invalidation.InvalidationPersistenceTest", groups={"functional"})
public class InvalidationPersistenceTest
extends MultipleCacheManagersTest {
    private static final String NON_TX_CACHE_NAME = "non-tx";
    private static final String PES_TX_CACHE_NAME = "p-tx";
    private static final String OPT_TX_CACHE_NAME = "o-tx";

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(2);
        Configuration nonTx = InvalidationPersistenceTest.invalidationConfiguration("a").build();
        this.cacheManagers.forEach(m -> m.defineConfiguration(NON_TX_CACHE_NAME, nonTx));
        Configuration ptx = InvalidationPersistenceTest.invalidationConfiguration("b").transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).build();
        this.cacheManagers.forEach(m -> m.defineConfiguration(PES_TX_CACHE_NAME, ptx));
        Configuration otx = InvalidationPersistenceTest.invalidationConfiguration("c").transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.OPTIMISTIC).build();
        this.cacheManagers.forEach(m -> m.defineConfiguration(OPT_TX_CACHE_NAME, otx));
        this.waitForClusterToForm(NON_TX_CACHE_NAME, PES_TX_CACHE_NAME, OPT_TX_CACHE_NAME);
    }

    private static ConfigurationBuilder invalidationConfiguration(String storeName) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).segmented(true)).storeName(storeName);
        return builder;
    }

    @DataProvider(name="caches")
    public static Object[][] cacheNames() {
        return new Object[][]{{NON_TX_CACHE_NAME}, {OPT_TX_CACHE_NAME}, {PES_TX_CACHE_NAME}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches")
    public void testPut(String cacheName) throws Exception {
        Cache cache1 = this.cache(0, cacheName);
        Cache cache2 = this.cache(1, cacheName);
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events1 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events2 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "put";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.putIfAbsent((Object)key, (Object)0))).isNull();
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.putIfAbsent((Object)key, (Object)-1))).isEqualTo(0);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(0);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.put((Object)key, (Object)1))).isEqualTo(0);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(1);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.put((Object)key, (Object)2))).isEqualTo(1);
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(2);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.replace((Object)key, (Object)3))).isEqualTo(2);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.replace((Object)key, (Object)4))).isEqualTo(3);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(4);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.remove((Object)key))).isEqualTo(4);
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.replace((Object)key, (Object)0))).isNull();
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache2.get((Object)key))).isNull();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches")
    public void testPutIgnoreReturnValue(String cacheName) throws Exception {
        AdvancedCache cache1 = this.cache(0, cacheName).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        AdvancedCache cache2 = this.cache(1, cacheName).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events1 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events2 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "put-ignore";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.putIfAbsent((Object)key, (Object)0))).isNull();
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.putIfAbsent((Object)key, (Object)-1))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(0)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(0);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.put((Object)key, (Object)1))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(0)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(1);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.put((Object)key, (Object)2))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(1)});
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(2);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.replace((Object)key, (Object)3))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(2)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.replace((Object)key, (Object)4))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(3)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(4);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.remove((Object)key))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(4)});
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.replace((Object)key, (Object)0))).isNull();
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache2.get((Object)key))).isNull();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches")
    public void testCompute(String cacheName) throws Exception {
        Cache cache1 = this.cache(0, cacheName);
        Cache cache2 = this.cache(1, cacheName);
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events1 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events2 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "compute";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            BiFunction<String, Integer, Integer> increment = (k, v) -> v != null ? v + 1 : 0;
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> 0))).isEqualTo(0);
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> -1))).isEqualTo(0);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(0);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.compute((Object)key, increment))).isEqualTo(1);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(1);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.compute((Object)key, increment))).isEqualTo(2);
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(2);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfPresent((Object)key, increment))).isEqualTo(3);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfPresent((Object)key, increment))).isEqualTo(4);
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(4);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> null))).isNull();
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> 0))).isNull();
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache2.get((Object)key))).isNull();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches")
    public void testComputeIgnoreReturnValue(String cacheName) throws Exception {
        AdvancedCache cache1 = this.cache(0, cacheName).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        AdvancedCache cache2 = this.cache(1, cacheName).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events1 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        LinkedBlockingQueue<Map.Entry<String, Listener.Observation>> events2 = new LinkedBlockingQueue<Map.Entry<String, Listener.Observation>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "compute-ignore";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            BiFunction<String, Integer, Integer> increment = (k, v) -> v != null ? v + 1 : 0;
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> 0))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(0)});
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> -1))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(0)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(0);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(0);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.compute((Object)key, increment))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(1)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(1);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.compute((Object)key, increment))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(2)});
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isEqualTo(2);
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfPresent((Object)key, increment))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(3)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfPresent((Object)key, increment))).satisfiesAnyOf(new ThrowingConsumer[]{result -> Assertions.assertThat((Integer)result).isNull(), result -> Assertions.assertThat((Integer)result).isEqualTo(4)});
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache2.get((Object)key))).isEqualTo(4);
            if (tm1 != null) {
                tm1.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache1.computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> null))).isNull();
            if (tm1 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm1.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.PRE));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isEqualTo(Map.entry(key, Listener.Observation.POST));
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache2.get((Object)key))).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            Assertions.assertThat((Integer)((Integer)cache2.computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> 0))).isNull();
            if (tm2 != null) {
                Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
                Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
                tm2.commit();
            }
            Assertions.assertThat((Object)((Map.Entry)events1.poll())).isNull();
            Assertions.assertThat((Object)((Map.Entry)events2.poll())).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)skipLoadCache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache1.get((Object)key))).isNull();
            Assertions.assertThat((Integer)((Integer)cache2.get((Object)key))).isNull();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    @Listener
    public static class InvalidationEventCollector {
        private final Collection<Map.Entry<String, Listener.Observation>> events;

        InvalidationEventCollector(Collection<Map.Entry<String, Listener.Observation>> events) {
            this.events = events;
        }

        @CacheEntryInvalidated
        public void invalidated(CacheEntryInvalidatedEvent<String, Integer> event) {
            this.events.add(Map.entry((String)event.getKey(), event.isPre() ? Listener.Observation.PRE : Listener.Observation.POST));
        }
    }
}

